package com.cku.thirdparty.oss;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
public class OssAutoConfiguration {

	@Value("${aliyun.oss.endpoint}")
	private String endpoint;

	@Value("${aliyun.oss.accessKeyId}")
	private String accessKeyId;

	@Value("${aliyun.oss.accessKeySecret}")
	private String accessKeySecret;

	@Bean
	public OssClientFactoryBean ossClientFactoryBean() {
		final OssClientFactoryBean factoryBean = new OssClientFactoryBean();
		log.info("======aliyun.oss.endpoint======"+endpoint);
		log.info("======aliyun.oss.accessKeyId======"+accessKeyId);
		log.info("======aliyun.oss.accessKeySecret======"+accessKeySecret);
		factoryBean.setEndpoint(this.endpoint);
		factoryBean.setAccessKeyId(this.accessKeyId);
		factoryBean.setAccessKeySecret(this.accessKeySecret);
		return factoryBean;
	}
}
