/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.PropertyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    public static String toJSON(Object o) {
        if (o instanceof List) {
            return JSONArray.fromObject((Object)o).toString();
        }
        return JSONObject.fromObject((Object)o).toString();
    }

    public static JSONObject firstOrDefault(JSONArray r) {
        if (r.size() > 0) {
            return r.getJSONObject(0);
        }
        return null;
    }

    private static Integer _toInt(Object o, Integer def) {
        if (o == null) {
            return def;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        if (o instanceof Long) {
            Long l = (Long)o;
            return l.intValue();
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return d.intValue();
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b != false ? 1 : 0;
        }
        return def;
    }

    private static Long _toLong(Object o, Long def) {
        if (o == null) {
            return def;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i.longValue();
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return d.longValue();
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b != false ? 1L : 0L;
        }
        return def;
    }

    private static Double _toDouble(Object o, Double def) {
        if (o == null) {
            return def;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i.doubleValue();
        }
        if (o instanceof Long) {
            Long l = (Long)o;
            return l.doubleValue();
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b != false ? 1.0 : 0.0;
        }
        return def;
    }

    public static Integer tryGetInt(JSONObject json, String key) {
        Object o = json.get(key);
        return JSONUtils._toInt(o, null);
    }

    public static Integer tryGetInt(JSONObject json, String key, Integer defVal) {
        Object o = json.get(key);
        return JSONUtils._toInt(o, defVal);
    }

    public static Integer tryGetInt(JSONArray json, int index) {
        Object o = json.get(index);
        return JSONUtils._toInt(o, null);
    }

    public static Long tryGetLong(JSONObject json, String key) {
        Object o = json.get(key);
        return JSONUtils._toLong(o, null);
    }

    public static Long tryGetLong(JSONArray json, int index) {
        Object o = json.get(index);
        return JSONUtils._toLong(o, null);
    }

    public static Double tryGetDouble(JSONObject json, String key) {
        Object o = json.get(key);
        return JSONUtils._toDouble(o, null);
    }

    public static Double tryGetDouble(JSONArray json, int index) {
        Object o = json.get(index);
        return JSONUtils._toDouble(o, null);
    }

    public static String tryGetString(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return o.toString();
    }

    public static String tryGetString(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return o.toString();
    }

    public static Object tryGetObject(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return o;
    }

    public static Object tryGetObject(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return o;
    }

    public static JSONObject tryGetJSONObject(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return (JSONObject)o;
    }

    public static JSONObject tryGetJSONObject(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return (JSONObject)o;
    }

    public static JSONArray tryGetList(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return (JSONArray)o;
    }

    public static JSONArray tryGetList(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }
        return (JSONArray)o;
    }

    public static List<JSONObject> arrCvt(JSONArray arr) {
        ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
        for (int i = 0; i < arr.size(); ++i) {
            ls.add(arr.getJSONObject(i));
        }
        return ls;
    }

    public static JSONObject toJSONX(String key, Object val) {
        JSONObject jo = new JSONObject();
        jo.put((Object)key, val);
        return jo;
    }

    public static Object convertObject(Object _data) {
        if (_data instanceof List) {
            List l = (List)_data;
            JSONArray arr = new JSONArray();
            for (Object o : l) {
                arr.add(JSONUtils.convertObject(o));
            }
            return arr;
        }
        if (_data instanceof String || _data instanceof Long || _data instanceof Integer || _data instanceof Double || _data instanceof Boolean) {
            return _data;
        }
        JsonConfig jc = new JsonConfig();
        jc.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonDateValueProcessor());
        jc.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return value == null;
            }
        });
        return JSONObject.fromObject((Object)_data, (JsonConfig)jc);
    }

    public static class JsonDateValueProcessor
    implements JsonValueProcessor {
        private String format = "yyyy-MM-dd HH:mm:ss";

        public JsonDateValueProcessor() {
        }

        public JsonDateValueProcessor(String format) {
            this.format = format;
        }

        public Object processArrayValue(Object paramObject, JsonConfig paramJsonConfig) {
            return this.process(paramObject);
        }

        public Object processObjectValue(String paramString, Object paramObject, JsonConfig paramJsonConfig) {
            return this.process(paramObject);
        }

        private Object process(Object value) {
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format, Locale.CHINA);
                return sdf.format(value);
            }
            return value == null ? "" : value.toString();
        }
    }
}

