/*
 * Decompiled with CFR 0.152.
 */
package com.cku.jpush;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import com.cku.jpush.JpushNotification;
import com.cku.util.MD5Generator;
import com.cku.util.SysConfig;

public class PushUtils {
    public static String jpushMasterSecret = "";
    public static String jpushAppKey = "";
    public static boolean isDebug = false;
    public static final String SAIL = "cab";
    public static JPushClient jpushClient;

    public static String getShowId(String userId) {
        return MD5Generator.generate(SAIL + userId).substring(8, 24);
    }

    public static void push_all_notification(JpushNotification notification) {
        PushPayload payloadAndroid = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.all()).setOptions(Options.newBuilder().setApnsProduction(isDebug).build()).setNotification(Notification.android((String)notification.getAlert(), (String)notification.getTitle(), notification.getExtras())).build();
        PushPayload payloadIos = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.all()).setOptions(Options.newBuilder().setApnsProduction(isDebug).build()).setNotification(Notification.ios((Object)notification.getAlert(), notification.getExtras())).build();
        try {
            PushResult resultAndroid = jpushClient.sendPush(payloadAndroid);
            PushResult resultIos = jpushClient.sendPush(payloadIos);
            System.out.println("resultAndroid" + resultAndroid);
            System.out.println("resultIos" + resultIos);
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
    }

    public static void push_alias_notification(String alias, String notification) {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{alias})).setNotification(Notification.alert((Object)notification)).setOptions(Options.newBuilder().setApnsProduction(isDebug).build()).build();
        try {
            jpushClient.sendPush(payload);
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
    }

    static {
        jpushMasterSecret = SysConfig.getInstance().getProperty("jpushMasterSecret");
        jpushAppKey = SysConfig.getInstance().getProperty("jpushAppKey");
        isDebug = "true".equals(SysConfig.getInstance().getProperty("jpushApns"));
        jpushClient = new JPushClient(jpushMasterSecret, jpushAppKey);
    }
}

