/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import java.io.File;
import java.util.Date;

public class PathUtils {
    private static final ThreadLocal<Long> s_index = new ThreadLocal();

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index);
        }
        return "";
    }

    public static String removeFileSpec(String path) {
        int index = path.lastIndexOf(File.separator);
        if (index != -1) {
            if (index == 0 || path.charAt(index - 1) == ':') {
                return path;
            }
            return path.substring(0, index);
        }
        return path;
    }

    public static String getFilename(String path) {
        int index;
        String path2 = path.replace('\\', '/');
        if (path2.length() > 0 && path2.charAt(path2.length() - 1) == '/') {
            path2 = path2.substring(0, path2.length() - 1);
        }
        if ((index = path2.lastIndexOf(47)) != -1) {
            if (index == 2 && path.charAt(1) == ':') {
                return null;
            }
            return path.substring(index + 1);
        }
        return null;
    }

    public static String mimeToExt(String e) {
        if (e.equalsIgnoreCase("text/plain")) {
            return ".txt";
        }
        if (e.equalsIgnoreCase("text/html")) {
            return ".html";
        }
        if (e.equalsIgnoreCase("video/courseware_easyhao")) {
            return ".dvi";
        }
        if (e.equalsIgnoreCase("video/mpg")) {
            return ".mpg";
        }
        if (e.equalsIgnoreCase("video/mp4")) {
            return ".mp4";
        }
        if (e.equalsIgnoreCase("video/avi")) {
            return ".avi";
        }
        if (e.equalsIgnoreCase("video/mkv")) {
            return ".mkv";
        }
        if (e.equalsIgnoreCase("video/rm")) {
            return ".rm";
        }
        if (e.equalsIgnoreCase("video/flv")) {
            return ".flv";
        }
        if (e.equalsIgnoreCase("video/wmv")) {
            return ".wmv";
        }
        if (e.equalsIgnoreCase("image/jpeg")) {
            return ".jpg";
        }
        if (e.equalsIgnoreCase("image/png")) {
            return ".png";
        }
        if (e.equalsIgnoreCase("image/bmp")) {
            return ".bmp";
        }
        if (e.equalsIgnoreCase("image/tiff")) {
            return ".tiff";
        }
        if (e.equalsIgnoreCase("image/gif")) {
            return ".gif";
        }
        if (e.equalsIgnoreCase("application/shockwave-flash")) {
            return ".swf";
        }
        if (e.equalsIgnoreCase("audio/mp3")) {
            return ".mp3";
        }
        if (e.equalsIgnoreCase("audio/aac")) {
            return ".aac";
        }
        if (e.equalsIgnoreCase("text/ms-word")) {
            return ".doc";
        }
        if (e.equalsIgnoreCase("text/ms-wordx")) {
            return ".docx";
        }
        if (e.equalsIgnoreCase("text/ms-ppt")) {
            return ".ppt";
        }
        if (e.equalsIgnoreCase("text/ms-pptx")) {
            return ".pptx";
        }
        if (e.equalsIgnoreCase("text/ms-excel")) {
            return ".xls";
        }
        if (e.equalsIgnoreCase("text/ms-excelx")) {
            return ".xlsx";
        }
        if (e.equalsIgnoreCase("text/pdf")) {
            return ".pdf";
        }
        return ".bin";
    }

    public static String extToMime(String e) {
        if (e.equalsIgnoreCase(".txt") || e.equalsIgnoreCase(".log")) {
            return "text/plain";
        }
        if (e.equalsIgnoreCase(".html") || e.equalsIgnoreCase(".htm")) {
            return "text/html";
        }
        if (e.equalsIgnoreCase(".dvi")) {
            return "video/courseware_easyhao";
        }
        if (e.equalsIgnoreCase(".mpg")) {
            return "video/mpg";
        }
        if (e.equalsIgnoreCase(".mp4")) {
            return "video/mp4";
        }
        if (e.equalsIgnoreCase(".avi")) {
            return "video/avi";
        }
        if (e.equalsIgnoreCase(".mkv")) {
            return "video/mkv";
        }
        if (e.equalsIgnoreCase(".rm") || e.equalsIgnoreCase(".rmvb")) {
            return "video/rm";
        }
        if (e.equalsIgnoreCase(".jpg") || e.equalsIgnoreCase(".jpeg")) {
            return "image/jpeg";
        }
        if (e.equalsIgnoreCase(".png")) {
            return "image/png";
        }
        if (e.equalsIgnoreCase(".bmp")) {
            return "image/bmp";
        }
        if (e.equalsIgnoreCase(".tiff")) {
            return "image/tiff";
        }
        if (e.equalsIgnoreCase(".gif")) {
            return "image/gif";
        }
        if (e.equalsIgnoreCase(".flv")) {
            return "video/flv";
        }
        if (e.equalsIgnoreCase(".wmv")) {
            return "video/wmv";
        }
        if (e.equalsIgnoreCase(".swf")) {
            return "application/shockwave-flash";
        }
        if (e.equalsIgnoreCase(".mp3")) {
            return "audio/mp3";
        }
        if (e.equalsIgnoreCase(".aac")) {
            return "audio/aac";
        }
        if (e.equalsIgnoreCase(".doc")) {
            return "text/ms-word";
        }
        if (e.equalsIgnoreCase(".docx")) {
            return "text/ms-wordx";
        }
        if (e.equalsIgnoreCase(".ppt")) {
            return "text/ms-ppt";
        }
        if (e.equalsIgnoreCase(".pptx")) {
            return "text/ms-pptx";
        }
        if (e.equalsIgnoreCase(".xls")) {
            return "text/ms-excel";
        }
        if (e.equalsIgnoreCase(".xlsx")) {
            return "text/ms-excelx";
        }
        if (e.equalsIgnoreCase(".pdf")) {
            return "text/pdf";
        }
        return "application/octet-stream";
    }

    private static boolean _isThisType(String mimeType, String[] typeList) {
        for (String ext : typeList) {
            if (!mimeType.equals(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVideo(String mimeType) {
        String[] vExts = new String[]{"video/mp4", "video/mkv", "video/wmv", "video/rm", "video/flv", "video/avi"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isStdCw(String mimeType) {
        String[] vExts = new String[]{"video/courseware_easyhao"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isDocument(String mimeType) {
        String[] vExts = new String[]{"text/pdf", "text/ms-excel", "text/ms-ppt", "text/ms-word", "text/ms-excelx", "text/ms-pptx", "text/ms-wordx", "text/html", "text/plain"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isPicture(String mimeType) {
        String[] vExts = new String[]{"image/jpeg", "image/png", "image/bmp", "image/gif", "image/tiff"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isFolder(String mimeType) {
        String[] vExts = new String[]{"application/recycle", "application/folder", "application/group-root"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isSystem(String mimeType) {
        String[] vExts = new String[]{"application/recycle", "application/group-root", "application/home"};
        return PathUtils._isThisType(mimeType, vExts);
    }

    public static boolean isSubPath(String path1, String path2) {
        String[] pathArr;
        String[] pathSubArr = path1.trim().split("/");
        if (pathSubArr.length < (pathArr = path2.trim().split("/")).length) {
            return false;
        }
        for (int i = 0; i < pathArr.length; ++i) {
            if (pathArr[i].equals(pathSubArr[i])) continue;
            return false;
        }
        return true;
    }

    public static String specFilename() {
        Date d = new Date();
        Long index = s_index.get();
        if (index == null) {
            index = 1L;
        }
        long threadId = Thread.currentThread().getId();
        s_index.set(index + 1L);
        return String.format("%d_%d_%d", threadId, index, d.getTime());
    }
}

