
// (function(designWidth, maxWidth) {
// 	var doc = document,
// 		win = window;
// 	var docEl = doc.documentElement;
// 	var tid;
// 	var rootItem,rootStyle;

// 	function refreshRem() {
// 		var width = docEl.getBoundingClientRect().width;
// 		if (!maxWidth) {
// 			maxWidth = 540;
// 		};
// 		if (width > maxWidth) {
// 			width = maxWidth;
// 		}
// 		//与淘宝做法不同，直接采用简单的rem换算方法1rem=100px
// 		var rem = width * 100 / designWidth;
// 		//兼容UC开始
// 		rootStyle="html{font-size:"+rem+'px !important}';
// 		rootItem = document.getElementById('rootsize') || document.createElement("style");
// 		if(!document.getElementById('rootsize')){
// 		document.getElementsByTagName("head")[0].appendChild(rootItem);
// 		rootItem.id='rootsize';
// 		}
// 		if(rootItem.styleSheet){
// 		rootItem.styleSheet.disabled||(rootItem.styleSheet.cssText=rootStyle)
// 		}else{
// 		try{rootItem.innerHTML=rootStyle}catch(f){rootItem.innerText=rootStyle}
// 		}
// 		//兼容UC结束
// 		docEl.style.fontSize = rem + "px";
// 	};
// 	refreshRem();

// 	win.addEventListener("resize", function() {
// 		clearTimeout(tid); //防止执行两次
// 		tid = setTimeout(refreshRem, 300);
// 	}, false);

// 	win.addEventListener("pageshow", function(e) {
// 		if (e.persisted) { // 浏览器后退的时候重新计算
// 			clearTimeout(tid);
// 			tid = setTimeout(refreshRem, 300);
// 		}
// 	}, false);

// 	if (doc.readyState === "complete") {
// 		doc.body.style.fontSize = "16px";
// 	} else {
// 		doc.addEventListener("DOMContentLoaded", function(e) {
// 			doc.body.style.fontSize = "16px";
// 		}, false);
// 	}
// })(750, 750);
'use strict';

/**
 * @param {Boolean} [normal = false] - 默认开启页面压缩以使页面高清;  
 * @param {Number} [baseFontSize = 100] - 基础fontSize, 默认100px;
 * @param {Number} [fontscale = 1] - 有的业务希望能放大一定比例的字体;
 */
const win = window;
export default win.flex = (normal, baseFontSize, fontscale) => {
  const _baseFontSize = baseFontSize || 100;
  const _fontscale = fontscale || 1;

  const doc = win.document;
  const ua = navigator.userAgent;
  const matches = ua.match(/Android[\S\s]+AppleWebkit\/(\d{3})/i);
  const UCversion = ua.match(/U3\/((\d+|\.){5,})/i);
  const isUCHd = UCversion && parseInt(UCversion[1].split('.').join(''), 10) >= 80;
  const isIos = navigator.appVersion.match(/(iphone|ipad|ipod)/gi);
  let dpr = win.devicePixelRatio || 1;
  if (!isIos && !(matches && matches[1] > 534) && !isUCHd) {
    // 如果非iOS, 非Android4.3以上, 非UC内核, 就不执行高清, dpr设为1;
    dpr = 1;
  }
  const scale = normal ? 1 : 1 / dpr;

  let metaEl = doc.querySelector('meta[name="viewport"]');
  if (!metaEl) {
    metaEl = doc.createElement('meta');
    metaEl.setAttribute('name', 'viewport');
    doc.head.appendChild(metaEl);
  }
  metaEl.setAttribute('content', `width=device-width,user-scalable=no,initial-scale=${scale},maximum-scale=${scale},minimum-scale=${scale}`);
  doc.documentElement.style.fontSize = normal ? '50px' : `${_baseFontSize / 2 * dpr * _fontscale}px`;
};
