import request from '../../../utils/request';
import Config from '../../../utils/config';

export const uploadImg = (data, progress) => {
  return request(
    {
      headers: { 'Content-Type': 'multipart/form-data' },
      url: Config.apis.catAppraisals.img,
      method: 'POST',
      data,
      onUploadProgress: function(progressEvent) {
        if (typeof progress === 'function') {
          progress(progressEvent);
        }
      },
    },
    'product',
  );
};
export const save = data => {
  return request(
    {
      url: Config.apis.catAppraisals.save,
      method: 'POST',
      data,
    },
    'product',
  );
};
export const mapApi = data => {
  return request(
    {
      url: Config.apis.catAppraisals.mapApi,
      method: 'GET',
      data,
    },
    'mapApi',
  );
};
//weixin
export const getAppId = data => {
  return request(
    {
      url: Config.apis.catAppraisals.getOpenId,
      method: 'POST',
      data,
    },
    'nothing',
  );
};

export const getConfig = data => {
  return request(
    {
      url: Config.apis.catAppraisals.getConfig,
      method: 'POST',
      data,
    },
    'nothing',
  );
};

export const getPayInfo = data => {
  return request(
    {
      url: Config.apis.catAppraisals.getPayInfo,
      method: 'POST',
      data,
    },
    'nothing',
  );
};

export const checkPayOrder = data => {
  return request(
    {
      url: Config.apis.catAppraisals.checkPayOrder,
      method: 'POST',
      data,
    },
    'nothing',
  );
};
