import 'antd-mobile/dist/antd-mobile.less';
import { Component } from 'react';
import DocumentTitle from 'react-document-title';
import { connect } from 'react-redux';
import styles from './index.less';
import { formatDate } from "../../../utils/helper";

import icon02 from '../assets/icon02.png';

@connect(({ trainer }) => ({ trainer }))
class index extends Component {
  state = {};
  componentWillMount = () => {
    const {club, token } = this.props.location.query;
    if(token){
      sessionStorage.setItem('token', token)
      sessionStorage.setItem('club', club)
    }
    this.props.dispatch({
      type: 'trainer/trainerCertificates',
      payload: {},
    });
  };
  componentDidMount = () => {};
  componentWillUnmount = () => {};
  onError = () => {
    const { data } = this.props.trainer;
    this.props.dispatch({
      type: 'trainer/updateState',
      payload: {
        data: {
          ...data,
          avatar: icon02,
        },
      },
    });
  };
  render() {
    const { data } = this.props.trainer;
    return (
      <DocumentTitle title="训练师资格证书">
        <div className={styles.body}>
          <div className={styles.body_t}>
            <div className={styles.body_c}>
              <div className={styles.b_t_bg}></div>
              <div className={styles.b_t_box}>
                <div className={styles.b_t_box_c}>
                  <div className={styles.b_t_box_c_i}>
                    <img src={data.avatar || icon02} alt="头像" onError={this.onError} />
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>姓名</span>
                    {data.memberName}
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>会员号</span>
                    {data.memberCode}
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>会员状态</span>
                    {data.overdue ? '无效' : '有效'}
                  </div>
                </div>
              </div>
              <div className={styles.b_title}>已获得CKU训练师证书信息</div>
              {data.list && data.list.length > 0  ?
                data.list.map((item, index) => (
                  <div key={item.certificateCode} className={styles.b_c_box}>
                    <div className={styles.b_c_box_i}>
                      <span>证书级别</span>
                      {item.certificateLevelCn}
                    </div>
                    <div className={styles.b_c_box_i}>
                      <span>证书编号</span>
                      {item.certificateCode}
                    </div>
                    <div className={styles.b_c_box_b}>
                      <span>签发日期</span>
                      {formatDate(item.issueDate)}
                    </div>
                  </div>
                ))
                :
                <div className={styles.normal}>
                  <div className={styles.icon}></div>
                  <div className={styles.text}>暂无证书</div>
                </div>
              }
            </div>
          </div>
        </div>
      </DocumentTitle>
    );
  }
}

export default index;
