import { Toast } from 'antd-mobile';
import 'antd-mobile/dist/antd-mobile.less';
import React, { Component } from 'react';
import DocumentTitle from 'react-document-title';
import { connect } from 'react-redux';
import styles from './index.less';

import icon02 from '../assets/icon02.png';

@connect(({ beautician }) => ({ beautician }))
class index extends Component {
  state = {};
  componentWillMount = () => {
    const { id, club, token } = this.props.location.query;
    if(token){
      sessionStorage.setItem('token', token)
      sessionStorage.setItem('club', club)
    }
    this.props.dispatch({
      type: 'beautician/groomerCertificates',
      payload: {
        id,
      },
    });
    this.props.dispatch({
      type: 'beautician/groomerFciCertificates',
      payload: {
        id,
      },
    });
  };
  componentDidMount = () => {};
  componentWillUnmount = () => {};
  onError = () => {
    const { data, dataFci } = this.props.beautician;
    this.props.dispatch({
      type: 'beautician/updateState',
      payload: {
        data: {
          ...data,
          avatar: icon02,
        },
      },
    });
  };
  openInfo = (id, overdue) => {
    if(overdue){
      Toast.info('会员已失效无法查看证书详情');
      return
    }
    this.props.history.push('/beauticianCertificate/info?id='+id);
    // window.location.reload();
  }
   openInfoFCI = (id, overdue) => {
    if(overdue){
      Toast.info('会员已失效无法查看证书详情');
      return
    }
    this.props.history.push('/beauticianCertificate/infoFci?id='+id);
    // window.location.reload();
  }
  render() {
    const { data, dataFci } = this.props.beautician;
    return (
      <DocumentTitle title="宠物美容师资格证书">
        <div className={styles.body}>
          <div className={styles.body_t}>
            <div className={styles.body_c}>
              <div className={styles.b_t_bg}></div>
              <div className={styles.b_t_box}>
                <div className={styles.b_t_box_c}>
                  <div className={styles.b_t_box_c_i}>
                    <img src={data.avatar || icon02} alt="头像" onError={this.onError} />
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>姓名</span>
                    {data.memberName}
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>会员号</span>
                    {data.memberCode}
                  </div>
                  <div className={styles.b_t_box_i}>
                    <span>会员状态</span>
                    {data.overdue ? '无效' : '有效'}
                  </div>
                  {/* <div className={styles.b_t_box_i}>
                    <span>证书编号</span>
                    {data.certificateCode}
                  </div> */}
                </div>
              </div>
              <div className={styles.b_title}>已获得CKU美容师证书信息</div>
              {data.list && data.list.length > 0  ?
                data.list.map((item, index) => (
                  <div key={item.certificateCode} onClick={this.openInfo.bind(this, item.id, data.overdue)} className={styles.b_c_box}>
                    <div className={styles.b_c_box_i}>
                      <span>证书级别</span>
                      {item.levelCn}
                    </div>
                    <div className={styles.b_c_box_i}>
                      <span>证书编号</span>
                      {item.certificateCode}
                    </div>
                    <div className={styles.b_c_box_b}>
                      <span>签发日期</span>
                      {item.issueDate}
                    </div>
                  </div>
                ))
                :
                <div className={styles.normal}>
                  <div className={styles.icon}></div>
                  <div className={styles.text}>暂无证书</div>
                </div>
              }
              <div className={styles.b_title}>已获得FCI美容师证书信息</div>
              {dataFci.list && dataFci.list.length > 0  ?
                dataFci.list.map((item, index) => (
                  <div key={item.id} onClick={this.openInfoFCI.bind(this, item.id, dataFci.overdue)} className={styles.b_c_box}>
                     <div className={styles.b_c_box_i}></div>
                    <div className={styles.b_c_box_i}>
                      <span>证书级别</span>
                      {item.levelCn}
                    </div>
                      <div className={styles.b_c_box_i}></div>
                    <div className={styles.b_c_box_b}>
                      <span>签发日期</span>
                      {item.issueDate}
                    </div>
                  </div>
                ))
                :
                <div className={styles.normal}>
                  <div className={styles.icon}></div>
                  <div className={styles.text}>暂无证书</div>
                </div>
              }

            </div>
          </div>
          {/* <div
            className={styles.body_b}
            onClick={() => {
              window.location.href = 'http://ckugc.cku.org.cn';
            }}
          >
            <div className={styles.btn}>点击了解更多证书</div>
          </div> */}
        </div>
      </DocumentTitle>
    );
  }
}

export default index;
