<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/passportOrder/">护照订单列表</a></li>
    <li class="active"><a href="${ctx}/passportOrder/form?id=${passportOrder.id}">护照订单<shiro:hasPermission
            name="passportOrder:edit">${not empty passportOrder.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="passportOrder:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/pingYang/edit" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">天猫订单号：</label>
        <div class="controls">
                ${passportOrder.tmallOrderCode}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">姓名：</label>
        <div class="controls">
                ${passportOrder.consigneeName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">电话：</label>
        <div class="controls">
                ${passportOrder.consigneePhone}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">购买套餐：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">下单时间：</label>
        <div class="controls">
            <fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">收货地址：</label>
        <div class="controls">
                ${passportOrder.consigneeProvince} ${passportOrder.consigneeCity} ${passportOrder.consigneeDistrict}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">详细地址：</label>
        <div class="controls">
                ${passportOrder.consigneeAddress}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名称：</label>
        <div class="controls">
                ${passportOrder.petName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">种类：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.petType, 'pet_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
               ${fns:getDictLabel(passportOrder.petGender, 'pet_gender', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <fmt:formatDate value="${passportOrder.petBirthday}" pattern="yyyy-MM-dd"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">毛色：</label>
        <div class="controls">
                ${passportOrder.petCoatColor}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">业务状态：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.businessState, 'passport_order_business_state', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div class="controls">
            <form:input path="identificationFlag" htmlEscape="false" maxlength="20" class="input-xlarge"/>
            <span class="help-inline"><font color="red">*仅在业务状态为待录入芯片或待打印贴纸时编辑有效</font> </span>
        </div>
    </div>
    <%--    <div class="control-group">
            <label class="control-label">快递类型：</label>
            <div class="controls">
                <form:input path="expressType" htmlEscape="false" maxlength="1" class="input-xlarge "/>
            </div>
        </div>--%>
    <div class="control-group">
        <label class="control-label">快递号：</label>
        <div class="controls">
            <form:input path="expressNumber" htmlEscape="false" maxlength="50" class="input-xlarge"/>
            <span class="help-inline"><font color="red">*仅在业务状态为待寄出时编辑有效</font> </span>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="passportOrder:pingYang:edit"><input id="btnSubmit" class="btn btn-primary"
                                                                       type="submit"
                                                                       value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>