<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>推荐人管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
        function excelAdd() {
            if(${page.count==0}){
                alert("查询结果为空，无法导出");
                return;
            }
            var parameter = "referrer.name=" + $("#name").val()
                + "&referrer.code=" + $("#code").val();
            $("#searchForm").attr("action", "${ctx}/referrer/referrer/exportExcel?" + parameter);
            $("#searchForm").submit();
            $("#searchForm").attr("action", "${ctx}/referrer/referrer/");
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/referrer/referrer/">推荐人列表</a></li>
		<%--<shiro:hasPermission name="referrer:referrer:edit"><li><a href="${ctx}/referrer/referrer/form">推荐人添加</a></li></shiro:hasPermission>--%>
	</ul>
	<form:form id="searchForm" modelAttribute="referrer" action="${ctx}/referrer/referrer/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>名字：</label>
				<form:input path="name" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>推荐人编码：</label>
				<form:input path="code" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
            <li class="btns"><input id="excel_btn" class="btn btn-primary" type="button" value="导出" onclick="excelAdd()"/>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<%--<th>id</th>--%>
				<th>名字</th>
				<th>电话</th>
				<th>推荐人编码</th>
				<th>业绩(推广数量)</th>
				<shiro:hasPermission name="referrer:referrer:edit"><th>管理</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="referrer">
			<tr>
			<%--	<td><a href="${ctx}/referrer/referrer/form?id=${referrer.id}">
					${referrer.id}
				</a></td>--%>
				<td>
					${referrer.name}
				</td>
				<td>
					${referrer.phone}
				</td>
				<td>
					${referrer.code}
				</td>
				<td>
					${referrer.count}
				</td>
				<shiro:hasPermission name="referrer:referrer:edit"><td>
    				<%--<a href="${ctx}/referrer/referrer/form?id=${referrer.id}">修改</a>
					<a href="${ctx}/referrer/referrer/delete?id=${referrer.id}" onclick="return confirmx('确认要删除该推荐人吗？', this.href)">删除</a>--%>
						<%--<a href="${ctx}/referrer/referrer/form?id=${referrer.id}">查看</a>--%>
						<a href="${ctx}/petStore/list?refererCode=${referrer.code}&refererName=${referrer.name}">查看</a>

					<c:if test="${referrer.status==0}">
						<a href="${ctx}/referrer/referrer/updateStatus?id=${referrer.id}&status=1"   onclick="return confirmx('确认要冻结吗？', this.href)">冻结</a>
					</c:if>
						<c:if test="${referrer.status==1}">
							<a href="${ctx}/referrer/referrer/updateStatus?id=${referrer.id}&status=0"   onclick="return confirmx('确认要解冻吗？', this.href)">解冻</a>
						</c:if>



				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>