package com.cab.passport.sys.util;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.*;

public class WXSignUtils {
	//商户Key
	private static String Key = "18439354c32b4ee4830e27d70761a0f4";

	/**
	 * 微信支付签名算法sign
	 * @param characterEncoding
	 * @param parameters
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static String createSign(String characterEncoding,SortedMap<Object,Object> parameters){
		StringBuffer sb = new StringBuffer();
		Set es = parameters.entrySet();//所有参与传参的参数按照accsii排序（升序）
		Iterator it = es.iterator();
		while(it.hasNext()) {
			Map.Entry entry = (Map.Entry)it.next();
			String k = (String)entry.getKey();
			Object v = entry.getValue();
			if(null != v && !"".equals(v)
					&& !"sign".equals(k) && !"key".equals(k)) {
				sb.append(k + "=" + v + "&");
			}
		}
		sb.append("key=" + Key);
		String sign = MD5Util.MD5Encode(sb.toString(), characterEncoding).toUpperCase();
		return sign;
	}
	public static SortedMap<String, String> dom4jXMLParse(String strXML) throws DocumentException {
		SortedMap<String, String> smap = new TreeMap<>();
		Document doc = DocumentHelper.parseText(strXML);
		Element root = doc.getRootElement();
		for (Iterator iterator = root.elementIterator(); iterator.hasNext();) {
			Element e = (Element) iterator.next();
			smap.put(e.getName(), e.getText());
		}
		return smap;
	}
	public static boolean isWechatSign(SortedMap<String, String> smap) {
		StringBuffer sb = new StringBuffer();
		Set es = smap.entrySet();
		Iterator it = es.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			String k = (String) entry.getKey();
			String v = (String) entry.getValue();
			if (!"sign".equals(k) && null != v && !"".equals(v) && !"key".equals(k)) {
				sb.append(k + "=" + v + "&");
			}
		}
		sb.append("key=" + Key);
		System.out.println(sb.toString());
		/** 验证的签名 */
		String sign = MD5Util.MD5Encode(sb.toString(), "utf-8").toUpperCase();
		/** 微信端返回的合法签名 */
		String validSign = ((String) smap.get("sign")).toUpperCase();
		return validSign.equals(sign);
	}

	/*public static void main(String[] args)  throws Exception{
		String message="<xml><appid><![CDATA[wxb1c434a7c9c2d3fd]]></appid><attach><![CDATA[备用参数，先留着，后面会有用的]]></attach><bank_type><![CDATA[GLB_DEBIT]]></bank_type><cash_fee><![CDATA[29120]]></cash_fee><coupon_count><![CDATA[1]]></coupon_count><coupon_fee>880</coupon_fee><coupon_fee_0><![CDATA[880]]></coupon_fee_0><coupon_id_0><![CDATA[4495715245]]></coupon_id_0><fee_type><![CDATA[CNY]]></fee_type><is_subscribe><![CDATA[N]]></is_subscribe><mch_id><![CDATA[1336491401]]></mch_id><nonce_str><![CDATA[EQ5vuaNTgLCCEnPs]]></nonce_str><openid><![CDATA[o_lq1vw-Qcjd5cPtT8vHC4SHy11k]]></openid><out_trade_no><![CDATA[b7adf8f49ede446387738b9a9c69d3a9]]></out_trade_no><result_code><![CDATA[SUCCESS]]></result_code><return_code><![CDATA[SUCCESS]]></return_code><sign><![CDATA[7CEDD505C2CB17B7B82ED29846965CE6]]></sign><time_end><![CDATA[20190114210427]]></time_end><total_fee>30000</total_fee><trade_type><![CDATA[APP]]></trade_type><transaction_id><![CDATA[4200000245201901148143595763]]></transaction_id></xml>";
		boolean result=isWechatSign(dom4jXMLParse(message),Key);
		System.out.println("验签结果："+result);
	}*/


}
