<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/passportOrder/club/certifyList">伴侣级认证列表</a></li>
    <%--<li><a href="${ctx}/passportOrder/club/searchForm?type=certify">认证</a></li>--%>
</ul>
<form:form id="searchForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/club/certifyList" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>芯片号：</label>
            <form:input path="identificationFlagLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠爱护照号：</label>
            <form:input path="cabPassportLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>认证日期：</label>
            <input name="certifyDateStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${passportOrder.certifyDateStart}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
            <input name="certifyDateEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${passportOrder.certifyDateEnd}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>宠物类别</th>
        <th>芯片号</th>
        <th>宠爱护照号</th>
        <th>认证时间</th>
        <th>认证人</th>
        <th>伴侣级认证</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="passportOrder">
        <tr>
            <td>
                    ${fns:getDictLabel(passportOrder.petType, 'pet_type', '')}
            </td>
            <td>
                    ${passportOrder.identificationFlag}
            </td>
            <td>
                    ${passportOrder.cabPassport}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.certifyDate}" pattern="yyyy-MM-dd HH:mm"/>
            </td>
            <td>
                    ${passportOrder.certifyBy}
            </td>
            <td>
                    ${fns:getDictLabel(passportOrder.certifyResult, 'passport_order_certify_result', '')}
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>