package com.thinkgem.jeesite.modules.sys.web;

import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.BaseFile;
import com.thinkgem.jeesite.modules.sys.service.FileService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;

@Controller
@RequestMapping("/pub/file")
public class FilePubController extends BaseController {
    @Autowired
    private FileService fileService;

    @RequestMapping(value = "image/{id}")
    public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
        BaseFile file = fileService.get(id);
        FileInputStream fis = new FileInputStream(FileService.fileDir + File.separator + file.getLocation() + File.separator + file.getName());
        response.setContentType("image/png");
        byte[] b = new byte[fis.available()];
        IOUtils.read(fis, b);
        fis.close();
        IOUtils.write(b, response.getOutputStream());
    }

    @RequestMapping(value = "pdf/{id}")
    public void pdf(@PathVariable String id, HttpServletResponse response) throws IOException {
        BaseFile file = fileService.get(id);
        FileInputStream fis = new FileInputStream(FileService.fileDir + File.separator + file.getLocation() + File.separator + file.getName());
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment;fileName="
                + URLEncoder.encode("dfs.pdf", "UTF-8"));
        byte[] b = new byte[fis.available()];
        IOUtils.read(fis, b);
        fis.close();
        IOUtils.write(b, response.getOutputStream());
    }

    @RequestMapping(value = "pdfs/{id}")
    public void pdsf(@PathVariable String id, HttpServletResponse response) throws IOException {
        BaseFile file = fileService.get(id);
        FileInputStream fis = new FileInputStream(FileService.fileDir + File.separator + file.getLocation() + File.separator + file.getName());
        response.setStatus(HttpServletResponse.SC_OK);
        response.setContentType("application/pdf;charset=UTF-8");
        BufferedInputStream input = new BufferedInputStream(fis);
        byte buffBytes[] = new byte[1024];
        ServletOutputStream out = response.getOutputStream();
        int read = 0;
        while ((read = input.read(buffBytes)) != -1) {
            out.write(buffBytes, 0, read);
        }
        out.flush();
        out.close();
    }


}
