
package com.cab.passport.tcbpetorder.web;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cab.passport.sys.app.APPUserUtils;
import com.cab.passport.sys.util.MultiUserProfile;
import com.cab.passport.tcbpetorder.entity.DogNose;
import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.cab.passport.tcbpetorder.service.DogNoseService;
import com.cab.passport.tcbpetorder.service.TcbPetOrderService;
import com.cab.passport.tcbpetorder.vo.TcbPetOrderVO;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.JSONUtils;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;

import net.sf.json.JSONObject;

/**
 * 天猫活体订单鼻纹
 */
@Controller
@RequestMapping(value = "/cku/app/tcbPetOrder/dogNose")
public class TcbPetOrderDogNoseController extends BaseController {

	@Autowired
	private DogNoseService dogNoseService;

	@Autowired
	private TcbPetOrderService tcbPetOrderService;

	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public String list(HttpServletRequest request, HttpServletResponse response) throws Exception {
		MultiUserProfile loginUser = APPUserUtils.getLoginUser();
		DogNose dogNose = new DogNose();
		dogNose.setDelFlag("0");
		dogNose.setCreateBy(new User(loginUser.getUserId()));
		Page<DogNose> page = dogNoseService.findPage(new Page<DogNose>(request, response), dogNose);
		List<JSONObject> list = new ArrayList<JSONObject>();
		for (DogNose po : page.getList()) {
			list.add(buildJo(po));
		}
		JSONObject data = new JSONObject();
		data.put("rc", 0);
		data.put("msg", "OK");
		data.put("list", list);
		data.put("total", page.getCount());
		return data.toString();
	}

	private JSONObject buildJo(DogNose po) {
		JSONObject data = new JSONObject();
		data.put("cabPassport", po.getCabPassport());
		data.put("petBreed", po.getPetBreed());
		data.put("petName", po.getPetName());
		data.put("petGender", po.getPetGender());
		data.put("petBirthday", DateFormatUtils.format(po.getPetBirthday(), "yyyy-MM-dd"));
		data.put("createDate", DateFormatUtils.format(po.getCreateDate(), "yyyy-MM-dd HH:mm:ss"));
		data.put("state", "已采集");
		return data;
	}

	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public RESTResponse add(@RequestBody String jo, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// 获取参数
		JSONObject json = JSONObject.fromObject(jo);
		if (StringUtils.isBlank(json.getString("id"))) {
			throw new ZAException("id不能为空！");
		}
		if (StringUtils.isBlank(json.getString("noseId"))) {
			throw new ZAException("noseId不能为空！");
		}
		MultiUserProfile loginUser = APPUserUtils.getLoginUser();
		return new RESTResponse("id",
				dogNoseService.saveNoseId(json.getString("noseId"), json.getString("id"), loginUser.getUserId()));
	}

	@RequestMapping(value = "/detail", method = RequestMethod.GET)
	@ResponseBody
	public RESTResponse detail(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException("芯片号不能为空！");
		}
		String cabPassport = request.getParameter("cabPassport");
		if (StringUtils.isBlank(cabPassport)) {
			throw new ZAException("护照号不能为空！");
		}
		TcbPetOrder tcbPetOrder = tcbPetOrderService.getOneByCabPassportAndidentificationFlag(identificationFlag,
				cabPassport);
		if (tcbPetOrder == null)
			throw new ZAException("没有查到犬只！");
		if (!"1".equals(tcbPetOrder.getPetType()))
			throw new ZAException("猫只无法办理鼻纹采集操作！");

		TcbPetOrderVO vo = new TcbPetOrderVO();
		BeanUtils.copyProperties(tcbPetOrder, vo);
		vo.setPetBirthday(DateFormatUtils.format(tcbPetOrder.getPetBirthday(), "yyyy-MM-dd"));
		DogNose dogNose = dogNoseService.getOneByTcbPetOrderId(tcbPetOrder.getId());
		vo.setState(dogNose != null ? "1" : "0");
		Object o = JSONUtils.convertObject(vo);
		return new RESTResponse(JSONObject.fromObject(o));
	}

}