/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * votesEntity
 * @author wj
 * @version 2020-05-12
 */
public class VoteUser extends DataEntity<VoteUser> {

	private static final long serialVersionUID = 1L;
	private String openId;		// open_id
	private String schoolCode;		// 学校编号
	private String totalVotes;		// 总票数
	private String remainingVotes;		// 剩余票数
	private String num;		// 投票次数

	public VoteUser() {
		super();
	}

	public VoteUser(String id){
		super(id);
	}

	@Length(min=1, max=64, message="open_id长度必须介于 1 和 64 之间")
	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	@Length(min=1, max=64, message="学校编号长度必须介于 1 和 64 之间")
	public String getSchoolCode() {
		return schoolCode;
	}

	public void setSchoolCode(String schoolCode) {
		this.schoolCode = schoolCode;
	}

	@Length(min=1, max=64, message="总票数长度必须介于 1 和 64 之间")
	public String getTotalVotes() {
		return totalVotes;
	}

	public void setTotalVotes(String totalVotes) {
		this.totalVotes = totalVotes;
	}

	@Length(min=1, max=64, message="剩余票数长度必须介于 1 和 64 之间")
	public String getRemainingVotes() {
		return remainingVotes;
	}

	public void setRemainingVotes(String remainingVotes) {
		this.remainingVotes = remainingVotes;
	}

	@Length(min=1, max=1, message="投票次数长度必须介于 1 和 1 之间")
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

}