/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.service;

import com.cab.passport.votes.dao.VoteUserDao;
import com.cab.passport.votes.entity.VoteUser;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * votesService
 * @author wj
 * @version 2020-05-12
 */
@Service
@Transactional(readOnly = true)
public class VoteUserService extends CrudService<VoteUserDao, VoteUser> {

	public VoteUser get(String id) {
		return super.get(id);
	}

	public List<VoteUser> findList(VoteUser voteUser) {
		return super.findList(voteUser);
	}

	public Page<VoteUser> findPage(Page<VoteUser> page, VoteUser voteUser) {
		return super.findPage(page, voteUser);
	}

	@Transactional(readOnly = false)
	public void save(VoteUser voteUser) {
		super.save(voteUser);
	}

	@Transactional(readOnly = false)
	public void delete(VoteUser voteUser) {
		super.delete(voteUser);
	}

	@Transactional(readOnly = false)
	public void saveVoteUser(VoteUser voteUser) {

		voteUser.setNum("0");
		User user = new User();
		user.setId("1");
		voteUser.setCreateBy(user);
		voteUser.setUpdateBy(user);
		voteUser.preInsert();
		dao.insert(voteUser);
    }
}