/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.marketing.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * jbhdEntity
 * 
 * @author jbhd
 * @version 2020-03-12
 */
public class PaymentOrderPayLog extends DataEntity<PaymentOrderPayLog> {

	private static final long serialVersionUID = 1L;
	private String payType; // 支付类型 1微信 2支付宝
	private String payTypeName; // 支付类型名称
	private String payMoney; // 支付金额
	private String payStatus; // 支付状态 0未支付 1已支付
	private Date payTime; // 支付时间
	private String payNo; // 本系统支付单号
	private String orderId; // 订单号
	private Date createTime; // 创建时间
	private Date finishTime; // 支付成功时间
	private String outsidePayNo; // 第三方单号
	private String bankType; // 付款银行
	private String buyerLogonId; // 支付宝或微信用户登录名

	public PaymentOrderPayLog() {
		super();
	}

	public PaymentOrderPayLog(String id) {
		super(id);
	}

	@Length(min = 0, max = 20, message = "支付类型 1微信 2支付宝长度必须介于 0 和 20 之间")
	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	@Length(min = 0, max = 20, message = "支付类型名称长度必须介于 0 和 20 之间")
	public String getPayTypeName() {
		return payTypeName;
	}

	public void setPayTypeName(String payTypeName) {
		this.payTypeName = payTypeName;
	}

	public String getPayMoney() {
		return payMoney;
	}

	public void setPayMoney(String payMoney) {
		this.payMoney = payMoney;
	}

	@Length(min = 0, max = 20, message = "支付状态 0未支付 1已支付长度必须介于 0 和 20 之间")
	public String getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(String payStatus) {
		this.payStatus = payStatus;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPayTime() {
		return payTime;
	}

	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}

	@Length(min = 0, max = 50, message = "本系统支付单号长度必须介于 0 和 50 之间")
	public String getPayNo() {
		return payNo;
	}

	public void setPayNo(String payNo) {
		this.payNo = payNo;
	}

	@Length(min = 0, max = 50, message = "订单号长度必须介于 0 和 50 之间")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	@Length(min = 0, max = 50, message = "第三方单号长度必须介于 0 和 50 之间")
	public String getOutsidePayNo() {
		return outsidePayNo;
	}

	public void setOutsidePayNo(String outsidePayNo) {
		this.outsidePayNo = outsidePayNo;
	}

	@Length(min = 0, max = 20, message = "付款银行长度必须介于 0 和 20 之间")
	public String getBankType() {
		return bankType;
	}

	public void setBankType(String bankType) {
		this.bankType = bankType;
	}

	@Length(min = 0, max = 200, message = "支付宝或微信用户登录名长度必须介于 0 和 200 之间")
	public String getBuyerLogonId() {
		return buyerLogonId;
	}

	public void setBuyerLogonId(String buyerLogonId) {
		this.buyerLogonId = buyerLogonId;
	}

}