/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.service;

import com.cab.passport.sys.payment.dao.PaymentChargingItemDao;
import com.cab.passport.sys.payment.dao.PaymentRecordDao;
import com.cab.passport.sys.payment.entity.PaymentChargingItem;
import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.cab.passport.sys.payment.entity.PaymentRecord;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 会员支付流水Service
 * @author lyy
 * @version 2016-07-18
 */
@Service
@Transactional(readOnly = true)
public class PaymentRecordService extends CrudService<PaymentRecordDao, PaymentRecord> {
	private static final String PAY_WX= "pay@WX";//微信支付
	private static final String PAY_XCWX = "pay@XCWX";//现场微信支付
	private static final String PAY_ALI= "pay@ALI";//支付宝支付
	private static final String PAY_ACCOUNT= "pay@ACCOUNT";//余额支付
	private static final String PAY_ALLIN= "pay@AALLIN";//通联支付

	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;

	public PaymentRecord get(String id) {
		return super.get(id);
	}

	public List<PaymentRecord> findList(PaymentRecord paymentRecord) {
		return super.findList(paymentRecord);
	}

	public Page<PaymentRecord> findPage(Page<PaymentRecord> page, PaymentRecord paymentRecord) {
		return super.findPage(page, paymentRecord);
	}

	@Transactional(readOnly = false)
	/**
	 * 后台保存付款记录，记录为oa
	 * 该方法不建议使用 fanhuibin
	 */
	public void save(PaymentRecord paymentRecord) {
		paymentRecord.setAlipayS("oa");
		super.save(paymentRecord);
	}

	/**
	 * 会员中心使用的方法
	 * 通过订单详情，生成流水记录
	 */
	@Transactional(readOnly = false)
	public void addRecordByOrder(PaymentOrder paymentOrder){
		PaymentRecord paymentRecord = new PaymentRecord();
		paymentRecord.setMemberCode(paymentOrder.getMemberCode());
		paymentRecord.setPaymentAmount(paymentOrder.getTotalPrice());
		paymentRecord.setPrice(paymentOrder.getTotalPrice());
		paymentRecord.setPaymentWay(paymentOrder.getPaymentWay());
		paymentRecord.setRunningNumber(paymentOrder.getOrderCode());
		paymentRecord.setPaymentState("2");
		paymentRecord.setPaymentTime(new Date());
		paymentRecord.setAlipayS("vip");
		if(paymentOrder.getIsRecharge().equals("1")){
			//如果是充值订单，直接标记为充值记录
			paymentRecord.setChargingItemId("0");
		}else{

			//如果不是充值，统一标记为业务订单支付
			paymentRecord.setChargingItemId("");
			String shortName = "";
			if("cku.org".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_ACCOUNT;
			}else if("24".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_WX;
			}else if("1".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_ALI;
			}else if("25".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_ACCOUNT;
			}else if("28".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_XCWX;
			}else if("30".equals(paymentOrder.getPaymentWay())){
				shortName = PAY_ALLIN;
			}
			PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
			paymentRecord.setChargingItemId(paymentChargingItem.getId());
		}
		paymentRecord.setChargingItemNum(1);
        paymentRecord.preInsert();
        paymentRecord.setId(paymentOrder.getId());
        dao.insert(paymentRecord);
	}

	/**
	 * @param paymentRecord
	 */
	@Transactional(readOnly = false)
	public void newRecord(PaymentRecord paymentRecord){
		paymentRecord.preInsert();
		dao.newRecord(paymentRecord);
	}

	/**
	 * 根据订单信息生成流水记录
	 */

	@Transactional(readOnly = false)
	public void delete(PaymentRecord paymentRecord) {
		super.delete(paymentRecord);
	}
}