/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.referrer.service;

import java.util.List;

import com.cab.passport.petstore.entity.PetStore;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cab.passport.referrer.entity.Referrer;
import com.cab.passport.referrer.dao.ReferrerDao;

import javax.servlet.http.HttpServletResponse;

/**
 * 推荐人Service
 * @author zfx
 * @version 2019-03-27
 */
@Service
@Transactional(readOnly = true)
public class ReferrerService extends CrudService<ReferrerDao, Referrer> {
	@Autowired
	private ReferrerDao referrerDao;

	public Referrer get(String id) {
		return super.get(id);
	}
	
	public List<Referrer> findList(Referrer referrer) {
		return super.findList(referrer);
	}
	
	public Page<Referrer> findPage(Page<Referrer> page, Referrer referrer) {
		return super.findPage(page, referrer);
	}
	
	@Transactional(readOnly = false)
	public void save(Referrer referrer) {
		super.save(referrer);
	}
	@Transactional(readOnly = false)
	public void updateStatus(String status,String id) {
		referrerDao.updateStatus(status,id);
	}
	
	@Transactional(readOnly = false)
	public void delete(Referrer referrer) {
		super.delete(referrer);
	}

	public void exportExcel(Referrer referrer, HttpServletResponse response) throws Exception {
		List<Referrer> exportList = super.findList(referrer);
		if (exportList.size() == 0) {
			throw new RuntimeException("没有符合条件的数据！");
		}
		new ExportExcel("", Referrer.class, 2).setDataList(exportList).write(response, "推荐人管理.xlsx").dispose();
	}
}