package com.cab.passport.petstore.pub.web;

import com.cab.passport.petstore.service.DogActivationService;
import com.thinkgem.jeesite.common.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping(value = "pub/dogActivation")
public class PubDogActivationController extends BaseController {

    @Autowired
    private DogActivationService service;

    @RequestMapping(value = "search", method = RequestMethod.GET)
    @ResponseBody
    public String search(HttpServletRequest request) {
        return service.search(request);
    }

    @RequestMapping(value = "details", method = RequestMethod.GET)
    @ResponseBody
    public String details(HttpServletRequest request) {
        return service.details(request);
    }

    @RequestMapping(value = "getPetStoreContact", method = RequestMethod.GET)
    @ResponseBody
    public String getPetStoreContact(HttpServletRequest request) {
        return service.getPetStoreContact(request);
    }

    @RequestMapping(value = "getPetOwnerContact", method = RequestMethod.GET)
    @ResponseBody
    public String getPetOwnerContact(HttpServletRequest request) {
        return service.getPetOwnerContact(request);
    }

}
