/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.web;

import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.entity.PassportOrderBusinessStateEnum;
import com.cab.passport.passportorder.service.PassportOrderService;
import com.cab.passport.passportorder.service.PassportOrderTmallService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 护照订单Controller
 *
 * @author
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "${adminPath}/passportOrder/tmall")
public class PassportOrderTmallController extends BaseController {

    @Autowired
    private PassportOrderService passportOrderService;
    @Autowired
    private PassportOrderTmallService passportOrderTmallService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/passportOrder/tmall/?repage";

    private static final String AUTHORITY_PRDFIX = "passportOrder:tmall:";

    @ModelAttribute
    public PassportOrder get(@RequestParam(required = false) String id) {
        PassportOrder entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = passportOrderService.get(id);
        }
        if (entity == null) {
            entity = new PassportOrder();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(PassportOrder passportOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<PassportOrder> page = passportOrderService.findPage(new Page<PassportOrder>(request, response), passportOrder);
        model.addAttribute("page", page);
        return "passportOrder/passportOrderTmallList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "form")
    public String form(PassportOrder passportOrder, Model model) {
        return "passportOrder/passportOrderTmallForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit")
    public String edit(String id, Model model, RedirectAttributes redirectAttributes) {
        PassportOrder passportOrder = passportOrderTmallService.get(id);
        if (passportOrder == null || !passportOrder.getBusinessState().equals(PassportOrderBusinessStateEnum.WAIT_FOR_INPUT_IDENTIFICATIONFLAG.getValue())) {
            addMessage(redirectAttributes, "该订单记录无法修改！");
            return REPAGE;
        }
        model.addAttribute("passportOrder", passportOrder);
        return "passportOrder/passportOrderTmallEditForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(PassportOrder passportOrder, Model model, RedirectAttributes redirectAttributes) {
        passportOrderTmallService.savePassportOrder(passportOrder);
        addMessage(redirectAttributes, "保存护照订单成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "view")
    public String view(PassportOrder passportOrder, Model model) {
        model.addAttribute("passportOrder", passportOrder);
        return "passportOrder/passportOrderTmallView";
    }
}