/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.builders.ThumbnailParameterBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import net.coobird.thumbnailator.makers.ScaledThumbnailMaker;
import net.coobird.thumbnailator.name.Rename;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.tasks.FileThumbnailTask;
import net.coobird.thumbnailator.tasks.StreamThumbnailTask;
import net.coobird.thumbnailator.tasks.ThumbnailTask;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Thumbnailator {
    private Thumbnailator() {
    }

    public static void createThumbnail(ThumbnailTask<?, ?> thumbnailTask) throws IOException {
        BufferedImage bufferedImage;
        ThumbnailParameter thumbnailParameter = thumbnailTask.getParam();
        BufferedImage bufferedImage2 = thumbnailTask.read();
        int n = thumbnailParameter.getType();
        if (thumbnailParameter.useOriginalImageType()) {
            int n2 = bufferedImage2.getType();
            n = n2 == 0 ? 2 : bufferedImage2.getType();
        }
        if (thumbnailParameter.getSize() != null) {
            int n3 = thumbnailParameter.getSize().width;
            int n4 = thumbnailParameter.getSize().height;
            bufferedImage = new FixedSizeThumbnailMaker().size(n3, n4).keepAspectRatio(thumbnailParameter.isKeepAspectRatio()).fitWithinDimensions(thumbnailParameter.fitWithinDimenions()).imageType(n).resizerFactory(thumbnailParameter.getResizerFactory()).make(bufferedImage2);
        } else if (!Double.isNaN(thumbnailParameter.getWidthScalingFactor())) {
            bufferedImage = new ScaledThumbnailMaker().scale(thumbnailParameter.getWidthScalingFactor(), thumbnailParameter.getHeightScalingFactor()).imageType(n).resizerFactory(thumbnailParameter.getResizerFactory()).make(bufferedImage2);
        } else {
            throw new IllegalStateException("Parameters to make thumbnail does not have scaling factor nor thumbnail size specified.");
        }
        for (ImageFilter imageFilter : thumbnailParameter.getImageFilters()) {
            bufferedImage = imageFilter.apply(bufferedImage);
        }
        thumbnailTask.write(bufferedImage);
    }

    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n, int n2) {
        Thumbnailator.validateDimensions(n, n2);
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        Dimension dimension2 = new Dimension(n, n2);
        Resizer resizer = DefaultResizerFactory.getInstance().getResizer(dimension, dimension2);
        BufferedImage bufferedImage2 = new FixedSizeThumbnailMaker(n, n2, true, true).resizer(resizer).make(bufferedImage);
        return bufferedImage2;
    }

    public static void createThumbnail(File file, File file2, int n, int n2) throws IOException {
        Thumbnailator.validateDimensions(n, n2);
        if (file == null) {
            throw new NullPointerException("Input file is null.");
        }
        if (file2 == null) {
            throw new NullPointerException("Output file is null.");
        }
        if (!file.exists()) {
            throw new IOException("Input file does not exist.");
        }
        String string = file2.getName();
        String string2 = null;
        if (string.contains(".") && string.lastIndexOf(46) != string.length() - 1) {
            int n3 = string.lastIndexOf(46);
            string2 = string.substring(n3 + 1);
        }
        String string3 = ThumbnailParameter.ORIGINAL_FORMAT;
        if (string2 != null) {
            for (String string4 : ImageIO.getWriterFormatNames()) {
                if (!string4.equals(string2)) continue;
                string3 = string4;
                break;
            }
            if (string3 == null) {
                throw new UnsupportedFormatException(string2, "No suitable ImageWriter found for " + string2 + ".");
            }
        }
        ThumbnailParameter thumbnailParameter = new ThumbnailParameter(new Dimension(n, n2), null, true, string3, ThumbnailParameter.DEFAULT_FORMAT_TYPE, Float.NaN, 2, null, DefaultResizerFactory.getInstance(), true);
        Thumbnailator.createThumbnail(new FileThumbnailTask(thumbnailParameter, file, file2));
    }

    public static BufferedImage createThumbnail(File file, int n, int n2) throws IOException {
        Thumbnailator.validateDimensions(n, n2);
        if (file == null) {
            throw new NullPointerException("Input file is null.");
        }
        return Thumbnailator.createThumbnail(ImageIO.read(file), n, n2);
    }

    public static Image createThumbnail(Image image, int n, int n2) {
        Thumbnailator.validateDimensions(n, n2);
        BufferedImage bufferedImage = new BufferedImageBuilder(image.getWidth(null), image.getHeight(null)).build();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, n, n2, null);
        graphics2D.dispose();
        return Thumbnailator.createThumbnail(bufferedImage, n, n2);
    }

    public static void createThumbnail(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        Thumbnailator.createThumbnail(inputStream, outputStream, ThumbnailParameter.ORIGINAL_FORMAT, n, n2);
    }

    public static void createThumbnail(InputStream inputStream, OutputStream outputStream, String string, int n, int n2) throws IOException {
        Thumbnailator.validateDimensions(n, n2);
        if (inputStream == null) {
            throw new NullPointerException("InputStream is null.");
        }
        if (outputStream == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        ThumbnailParameter thumbnailParameter = new ThumbnailParameter(new Dimension(n, n2), null, true, string, ThumbnailParameter.DEFAULT_FORMAT_TYPE, Float.NaN, 2, null, DefaultResizerFactory.getInstance(), true);
        Thumbnailator.createThumbnail(new StreamThumbnailTask(thumbnailParameter, inputStream, outputStream));
    }

    public static Collection<File> createThumbnailsAsCollection(Collection<? extends File> collection, Rename rename, int n, int n2) throws IOException {
        Thumbnailator.validateDimensions(n, n2);
        if (collection == null) {
            throw new NullPointerException("Collection of Files is null.");
        }
        if (rename == null) {
            throw new NullPointerException("Rename is null.");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ThumbnailParameter thumbnailParameter = new ThumbnailParameterBuilder().size(n, n2).build();
        for (File file : collection) {
            File file2 = new File(file.getParent(), rename.apply(file.getName(), thumbnailParameter));
            Thumbnailator.createThumbnail(file, file2, n, n2);
            arrayList.add(file2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static void createThumbnails(Collection<? extends File> collection, Rename rename, int n, int n2) throws IOException {
        Thumbnailator.validateDimensions(n, n2);
        if (collection == null) {
            throw new NullPointerException("Collection of Files is null.");
        }
        if (rename == null) {
            throw new NullPointerException("Rename is null.");
        }
        ThumbnailParameter thumbnailParameter = new ThumbnailParameterBuilder().size(n, n2).build();
        for (File file : collection) {
            File file2 = new File(file.getParent(), rename.apply(file.getName(), thumbnailParameter));
            Thumbnailator.createThumbnail(file, file2, n, n2);
        }
    }

    private static void validateDimensions(int n, int n2) {
        if (n <= 0 && n2 <= 0) {
            throw new IllegalArgumentException("Destination image dimensions must not be less than 0 pixels.");
        }
        if (n <= 0 || n2 <= 0) {
            String string = n == 0 ? "width" : "height";
            throw new IllegalArgumentException("Destination image " + string + " must not be " + "less than or equal to 0 pixels.");
        }
    }
}

