/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.tcbpetorder.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cab.passport.tcbpetorder.dao.TcbPetOrderDao;
import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 淘宠宝宠物订单Service
 *
 * @author lgl
 * @version 2018-11-22
 */
@Service
@Transactional(readOnly = true)
public class TcbPetOrderService extends CrudService<TcbPetOrderDao, TcbPetOrder> {

	public TcbPetOrder get(String id) {
		return super.get(id);
	}

	public List<TcbPetOrder> findList(TcbPetOrder tcbPetOrder) {
		return super.findList(tcbPetOrder);
	}

	public Page<TcbPetOrder> findPage(Page<TcbPetOrder> page, TcbPetOrder tcbPetOrder) {
		return super.findPage(page, tcbPetOrder);
	}

	@Transactional(readOnly = false)
	public void save(TcbPetOrder tcbPetOrder) {
		super.save(tcbPetOrder);
	}

	@Transactional(readOnly = false)
	public void delete(TcbPetOrder tcbPetOrder) {
		super.delete(tcbPetOrder);
	}

	@Transactional(readOnly = false)
	public TcbPetOrder getOneByCabPassportAndidentificationFlag(String identificationFlag, String cabPassport) {
		return dao.getOneByCabPassportAndidentificationFlag(identificationFlag, cabPassport);
	}

}