/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.service;

import com.cab.passport.votes.dao.SchoolDao;
import com.cab.passport.votes.entity.School;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.PageBeanResult;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * votesService
 * @author wj
 * @version 2020-05-12
 */
@Service
@Transactional(readOnly = true)
public class SchoolService extends CrudService<SchoolDao, School> {
	@Autowired
	private  SchoolDao schoolDao;

	public School get(String id) {
		return super.get(id);
	}

	public List<School> findList(School school) {
		return super.findList(school);
	}

	public Page<School> findPage(Page<School> page, School school) {
		return super.findPage(page, school);
	}

	@Transactional(readOnly = false)
	public void save(School school) {
		super.save(school);
	}

	@Transactional(readOnly = false)
	public void delete(School school) {
		super.delete(school);
	}

	public RESTResponse getList(HttpServletRequest request) {
		String id = request.getParameter("id");
		School School = new School();
		if (StringUtils.isNotBlank(id)) {
			School.setId(id);
		}
		Page<School> page = findPage(new Page<School>(1, 30), School);
		List<JSONObject> list = new ArrayList<JSONObject>();
		for (School po : page.getList()) {
			list.add(buildJo(po));
		}
		return new RESTResponse("list", new PageBeanResult<JSONObject>(list, page.getCount()));
	}

	private JSONObject buildJo(School po) {
		JSONObject data = new JSONObject();
		data.put("schoolCode", po.getSchoolCode());
		data.put("schoolName", po.getSchoolName());
		data.put("votes", po.getVotes());
		data.put("catName", po.getCatName());
		data.put("catImg", po.getCatImg());
		data.put("photo", po.getPhoto());
		data.put("catDescription", po.getCatDescription());
		return data;
	}
}