package com.cab.passport.petstore.pub.web;

import com.cab.passport.petstore.service.PetStoreService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping(value = "pub/petStore")
public class PubPetStoreController extends BaseController {

    @Autowired
    private PetStoreService service;

    @RequestMapping(value = "checkInviteCode/{inviteCode}", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse checkInviteCode(@PathVariable("inviteCode") String inviteCode) {
        return service.checkInviteCode(inviteCode);
    }

    @RequestMapping(value = "activatePetStore", method = RequestMethod.POST)
    @ResponseBody
    public RESTResponse activatePetStore(@RequestBody String json, HttpServletRequest request) {
        return service.activatePetStore(json, request);
    }

//    @RequestMapping(value = "activatePetStoreByChannel", method = RequestMethod.POST)
//    @ResponseBody
//    public RESTResponse activatePetStoreByChannel(@RequestBody String json, HttpServletRequest request) {
//        return service.activatePetStoreByChannel(json, request);
//    }

}
