/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.tcbpetorder.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹Entity
 * 
 * @author xx
 * @version 2020-10-23
 */
public class DogNose extends DataEntity<DogNose> {

	private static final long serialVersionUID = 1L;
	private String tcbPetOrderId; // 活体订单ID
	private String identificationFlag; // 芯片号
	private String cabPassport; // 护照号
	private String noseCode; // 鼻纹编号
	private String noseId; // 鼻纹ID-第三方

	private String petName; // 宠物名称
	private String petGender; // 宠物性别
	private Date petBirthday; // 宠物生日
	private String petBreed; // 宠物品种

	public String getPetName() {
		return petName;
	}

	public void setPetName(String petName) {
		this.petName = petName;
	}

	public String getPetGender() {
		return petGender;
	}

	public void setPetGender(String petGender) {
		this.petGender = petGender;
	}

	public Date getPetBirthday() {
		return petBirthday;
	}

	public void setPetBirthday(Date petBirthday) {
		this.petBirthday = petBirthday;
	}

	public String getPetBreed() {
		return petBreed;
	}

	public void setPetBreed(String petBreed) {
		this.petBreed = petBreed;
	}

	public DogNose() {
		super();
	}

	public DogNose(String id) {
		super(id);
	}

	@Length(min = 1, max = 64, message = "活体订单ID长度必须介于 1 和 64 之间")
	public String getTcbPetOrderId() {
		return tcbPetOrderId;
	}

	public void setTcbPetOrderId(String tcbPetOrderId) {
		this.tcbPetOrderId = tcbPetOrderId;
	}

	@Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min = 1, max = 20, message = "护照号长度必须介于 1 和 20 之间")
	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	@Length(min = 0, max = 64, message = "鼻纹编号长度必须介于 0 和 64 之间")
	public String getNoseCode() {
		return noseCode;
	}

	public void setNoseCode(String noseCode) {
		this.noseCode = noseCode;
	}

	@Length(min = 0, max = 64, message = "鼻纹ID-第三方长度必须介于 0 和 64 之间")
	public String getNoseId() {
		return noseId;
	}

	public void setNoseId(String noseId) {
		this.noseId = noseId;
	}

}