<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>线下订单汇总表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/offlineorder/offlineOrder/">线下订单汇总表列表</a></li>
		<shiro:hasPermission name="offlineorder:offlineOrder:edit"><li><a href="${ctx}/offlineorder/offlineOrder/form">线下订单汇总表添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="offlineOrder" action="${ctx}/offlineorder/offlineOrder/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>订单号：</label>
				<form:input path="orderCode" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>芯片编号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>宠爱护照号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>客户姓名：</label>
				<form:input path="customerName" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>宠物种类：</label>
				<form:select path="petType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('pet_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>成交时间：</label>
				<input name="beginOrderTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${offlineOrder.beginOrderTime}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endOrderTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${offlineOrder.endOrderTime}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单编号</th>
				<th>成交时间</th>
				<th>门店商家</th>
				<th>成交金额</th>
				
				<th>宠物种类</th>
				<th>品种</th>
				<th>宠物性别</th>
				<th>毛色</th>
				<th>出生日期</th>
				<th>芯片编号</th>
				<th>宠爱护照号</th>
				<th>级别</th>
				<th>物流状态</th>
				<th>是否需要保险</th>
				<th>保单操作阶段备注</th>
				<th>发货地</th>
				<th>客户姓名</th>
				<th>客户地址</th>
				<shiro:hasPermission name="offlineorder:offlineOrder:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="offlineOrder">
			<tr>
				<td><a href="${ctx}/offlineorder/offlineOrder/form?id=${offlineOrder.id}">
					${offlineOrder.orderCode}
				</a></td>
				<td>
					<fmt:formatDate value="${offlineOrder.orderTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${offlineOrder.storeName}
				</td>
				<td>
					${offlineOrder.totalPrice}
				</td>
				
				<td>
					${fns:getDictLabel(offlineOrder.petType, 'pet_type', '')}
				</td>
				<td>
					${offlineOrder.petBreeds}
				</td>
				<td>
					${fns:getDictLabel(offlineOrder.petGender, 'pet_gender', '')}
				</td>
				<td>
					${offlineOrder.petCoatColor}
				</td>
				<td>
					<fmt:formatDate value="${offlineOrder.petBirthdate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${offlineOrder.identificationFlag}
				</td>
				<td>
					${offlineOrder.pedigreeCertified}
				</td>
				<td>
					${offlineOrder.level}
				</td>
				<td>
					${offlineOrder.expressState}
				</td>
				<td>
					${offlineOrder.isInsure}
				</td>
				<td>
					${offlineOrder.insurancePolicyRemark}
				</td>
				<td>
					${offlineOrder.deliveryAddress}
				</td>
				<td>
					${offlineOrder.customerName}
				</td>
				<td>
					${offlineOrder.customerAddress}
				</td>
				<shiro:hasPermission name="offlineorder:offlineOrder:edit"><td>
    				<a href="${ctx}/offlineorder/offlineOrder/form?id=${offlineOrder.id}">修改</a>
					<a href="${ctx}/offlineorder/offlineOrder/delete?id=${offlineOrder.id}" onclick="return confirmx('确认要删除该线下订单汇总表吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>