/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.pub.web;

import com.cab.passport.passportorder.dao.CompanionDogAppraisalDao;
import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.CompanionDogAppraisal;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.pub.entity.PetClass;
import com.cab.passport.passportorder.service.PassportOrderService;
import com.cab.passport.tcbpetorder.dao.TcbPetOrderDao;
import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 护照订单Controller
 *
 * @author lgl
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "cab/petClass")
public class CabPetClassController extends BaseController {

    @Autowired
    private PassportOrderDao passportOrderDao;
    @Autowired
    private TcbPetOrderDao tcbPetOrderDao;
    @Autowired
    private PassportOrderService passportOrderService;
    @Autowired
    CompanionDogAppraisalDao companionDogAppraisalDao;

    @RequestMapping(value = "search")
    @ResponseBody
    public Object search(HttpServletRequest request) {
        PassportOrder po = passportOrderDao.getByIdentificationFlag(request.getParameter("identificationFlag"));
        if (po == null) {
            TcbPetOrder tcbPetOrder = tcbPetOrderDao.getByIdentificationFlag(request.getParameter("identificationFlag"));
            if (tcbPetOrder == null) {
                CompanionDogAppraisal companionDogAppraisal = companionDogAppraisalDao.findByIdentificationFlag(request.getParameter("identificationFlag"));
                if(companionDogAppraisal == null ){
                    throw new ZAException("输入信息不符，请核对后从新输入");
                }else {
                    return buildPetClass(companionDogAppraisal);
                }
            } else {
                return buildPetClass(tcbPetOrder);
            }
        } else {
            return buildPetClass(po);
        }
    }

    /**
     * oa-web 系统查询使用
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/cabPassport")
    @ResponseBody
    public Object getByCabPassport(HttpServletRequest request) {
        String cabPassport = request.getParameter("cabPassport");
        PassportOrder po = passportOrderDao.getByCabPassport(cabPassport);
        if (po == null) {
            return null;
        }
        PetClass petClass = new PetClass();
        if (po.getPackageType().equals("2") && null != po.getCertifyDate() && po.getCertifyResult().equals("1")) {
            petClass.setPetClass("C级");
        } else {
            petClass.setPetClass("");
        }
        petClass.setPetName(po.getPetName());
        petClass.setPetGender(DictUtils.getDictLabel(po.getPetGender(), "pet_gender", ""));
        petClass.setPetCoatColor(po.getPetCoatColor());
        petClass.setPetType(DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        petClass.setIdentificationFlag(po.getIdentificationFlag());
        petClass.setPetBirthday(DateFormatUtils.format(po.getPetBirthday(), "yyyy-MM-dd"));
        petClass.setPetBreead("无(C级可无品种)");
        petClass.setCabPassport(po.getCabPassport());
        petClass.setCabRegisterCode(po.getCabRegisterCode());
        return petClass;
    }

    @RequestMapping(value = "active", method = RequestMethod.POST)
    @ResponseBody
    public RESTResponse active(@RequestBody String json) {

        return passportOrderService.active(json);
    }

    private PetClass buildPetClass(PassportOrder po) {
        PetClass petClass = new PetClass();
        if (po.getPackageType().equals("2") && null != po.getCertifyDate() && po.getCertifyResult().equals("0")) {
            petClass.setPetClass("C");
            petClass.setPetClassName("伴侣级（C）");
        } else {
            petClass.setPetClass("");
            petClass.setPetClassName("");
        }
        petClass.setPetName(po.getPetName());
        petClass.setPetGender(po.getPetGender());
        petClass.setPetCoatColor(po.getPetCoatColor());
        petClass.setPetType(DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        petClass.setIdentificationFlag(po.getIdentificationFlag());
        petClass.setPetBirthday(DateFormatUtils.format(po.getPetBirthday(), "yyyy-MM-dd"));
        petClass.setPetBreead("无(C级可无品种)");
        petClass.setCabPassport(po.getCabPassport());
        petClass.setCabRegisterCode(po.getCabRegisterCode());
        //以下为激活信息
        String petOwnerName = po.getConsigneeName();
        String petOwnerMobile = po.getConsigneePhone();
        String petOwnerAddress = po.getConsigneeProvince() + "," + po.getConsigneeCity();
        if (StringUtils.isNotBlank(po.getPetOwnerName())) {
            petOwnerName = po.getPetOwnerName();
        }
        if (StringUtils.isNotBlank(po.getPetOwnerMobile())) {
            petOwnerMobile = po.getPetOwnerMobile();
        }
        if (StringUtils.isNotBlank(po.getPetOwnerAddress())) {
            petOwnerAddress = po.getPetOwnerAddress();
        }
        petClass.setPetOwnerName(petOwnerName);
        petClass.setPetOwnerMobile(petOwnerMobile);
        petClass.setPetOwnerAddress(petOwnerAddress);
        petClass.setActiveState(StringUtils.isNotBlank(po.getPetOwnerMobile()) ? "1" : "0");
        return petClass;
    }

    private PetClass buildPetClass(TcbPetOrder po) {
        PetClass petClass = new PetClass();
        petClass.setPetName(po.getPetName());
        petClass.setPetClassName("伴侣级（C）");
        petClass.setPetClass("C");
        petClass.setPetGender(po.getPetGender());
        petClass.setPetCoatColor(po.getPetCoatColor());
        petClass.setPetType(DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        petClass.setIdentificationFlag(po.getIdentificationFlag());
        petClass.setPetBirthday(DateFormatUtils.format(po.getPetBirthday(), "yyyy-MM-dd"));
        petClass.setPetBreead(po.getPetBreed());
        petClass.setCabPassport(po.getCabPassport());
        return petClass;
    }
    private PetClass buildPetClass(CompanionDogAppraisal po) {
        PetClass petClass = new PetClass();
        petClass.setPetName(po.getPetName());
        petClass.setPetClassName("伴侣级（C）");
        petClass.setPetClass("C");
        petClass.setPetGender(po.getPetGender());
        petClass.setPetCoatColor(po.getPetColor());
        petClass.setPetType(DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        petClass.setIdentificationFlag(po.getIdentificationFlag());
        petClass.setPetBirthday(DateFormatUtils.format(po.getPetBirthdate(), "yyyy-MM-dd"));
        petClass.setPetBreead("");
        petClass.setCabPassport(po.getPassportNo());
        return petClass;
    }
}