/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.referrer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cab.passport.petstore.entity.PetStore;
import com.cab.passport.referrer.dao.ReferrerDao;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cab.passport.referrer.entity.Referrer;
import com.cab.passport.referrer.service.ReferrerService;

/**
 * 推荐人Controller
 * @author zfx
 * @version 2019-03-27
 */
@Controller
@RequestMapping(value = "${adminPath}/referrer/referrer")
public class ReferrerController extends BaseController {

	@Autowired
	private ReferrerService referrerService;
	@Autowired
	private ReferrerDao referrerDao;
	
	@ModelAttribute
	public Referrer get(@RequestParam(required=false) String id) {
		Referrer entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = referrerService.get(id);
		}
		if (entity == null){
			entity = new Referrer();
		}
		return entity;
	}
	
	@RequiresPermissions("referrer:referrer:view")
	@RequestMapping(value = {"list", ""})
	public String list(Referrer referrer, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Referrer> page = referrerService.findPage(new Page<Referrer>(request, response), referrer); 
		model.addAttribute("page", page);
		return "passport/referrer/referrerList";
	}

	@RequiresPermissions("referrer:referrer:view")
	@RequestMapping(value = "form")
	public String form(Referrer referrer, Model model) {
		model.addAttribute("referrer", referrer);
		return "passport/referrer/referrerForm";
	}

	@RequiresPermissions("referrer:referrer:edit")
	@RequestMapping(value = "save")
	public String save(Referrer referrer, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, referrer)){
			return form(referrer, model);
		}
		//检查推荐码是否有重复
		Referrer referrerDb=referrerDao.getByCode(referrer.getCode());
		if(null!=referrerDb){
			model.addAttribute("referrer",referrer);
			addMessage(model, "推荐码重复！");
			return "passport/referrer/referrerForm";
		}
		referrerService.save(referrer);
		addMessage(redirectAttributes, "保存推荐人成功");
		return "redirect:"+Global.getAdminPath()+"/referrer/referrer/?repage";
	}
	@RequiresPermissions("referrer:referrer:edit")
	@RequestMapping(value = "updateStatus")
	public String updateStatus(String id,String status, Model model, RedirectAttributes redirectAttributes) {
		referrerService.updateStatus(status,id);
		addMessage(redirectAttributes, "修改推荐人状态成功");
		return "redirect:"+Global.getAdminPath()+"/referrer/referrer/?repage";
	}
	
	@RequiresPermissions("referrer:referrer:edit")
	@RequestMapping(value = "delete")
	public String delete(Referrer referrer, RedirectAttributes redirectAttributes) {
		referrerService.delete(referrer);
		addMessage(redirectAttributes, "删除推荐人成功");
		return "redirect:"+Global.getAdminPath()+"/referrer/referrer/?repage";
	}
	@RequestMapping(value = "exportExcel")
	public void exportExcel(Referrer referrer, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			referrerService.exportExcel(referrer, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
		}
	}

}