/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petlostandfound.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 寻宠寻主Entity
 *
 * @author lgl
 * @version 2018-10-24
 */
public class PetLostAndFound extends DataEntity<PetLostAndFound> {

    private static final long serialVersionUID = 1L;
    private String lostAndFoundCode;        // 寻宠寻主编号
    private String lostAndFoundType;        // 寻宠寻主类型:1寻宠;2寻主
    private String identificationFlag;        // 芯片号
    private String petName;        // 宠物名称
    private String petType;        // 宠物种类:1狗;2猫
    private String petGender;        // 宠物性别:1公;2母
    private String petCoatColor;        // 宠物毛色
    private String city;        // 城市
    private String location;        // 地点
    private Date time;        // 时间
    private String phone;        // 联系电话
    private String linkman;        // 联系人
    private String picture;        // 照片
    private String reviewState;        // 审核状态：未审核0；通过1；未通过2
    private String reviewRemarks;        // 审核的意见
    private String remarks;        //补充信息

    public PetLostAndFound() {
        super();
    }

    public PetLostAndFound(String id) {
        super(id);
    }

    @Length(min = 1, max = 20, message = "寻宠寻主编号长度必须介于 1 和 20 之间")
    public String getLostAndFoundCode() {
        return lostAndFoundCode;
    }

    public void setLostAndFoundCode(String lostAndFoundCode) {
        this.lostAndFoundCode = lostAndFoundCode;
    }

    @Length(min = 1, max = 1, message = "寻宠寻主类型:1寻宠;2寻主长度必须介于 1 和 1 之间")
    public String getLostAndFoundType() {
        return lostAndFoundType;
    }

    public void setLostAndFoundType(String lostAndFoundType) {
        this.lostAndFoundType = lostAndFoundType;
    }

    @Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
    public String getIdentificationFlag() {
        return identificationFlag;
    }

    public void setIdentificationFlag(String identificationFlag) {
        this.identificationFlag = identificationFlag;
    }

    @Length(min = 1, max = 50, message = "宠物名称长度必须介于 1 和 50 之间")
    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    @Length(min = 1, max = 1, message = "宠物种类:1狗;2猫长度必须介于 1 和 1 之间")
    public String getPetType() {
        return petType;
    }

    public void setPetType(String petType) {
        this.petType = petType;
    }

    @Length(min = 1, max = 1, message = "宠物性别:1公;2母长度必须介于 1 和 1 之间")
    public String getPetGender() {
        return petGender;
    }

    public void setPetGender(String petGender) {
        this.petGender = petGender;
    }

    @Length(min = 1, max = 50, message = "宠物毛色长度必须介于 1 和 50 之间")
    public String getPetCoatColor() {
        return petCoatColor;
    }

    public void setPetCoatColor(String petCoatColor) {
        this.petCoatColor = petCoatColor;
    }

    @Length(min = 1, max = 20, message = "城市长度必须介于 1 和 20 之间")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Length(min = 1, max = 20, message = "地点长度必须介于 1 和 20 之间")
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Length(min = 1, max = 20, message = "联系电话长度必须介于 1 和 20 之间")
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Length(min = 1, max = 20, message = "联系人长度必须介于 1 和 20 之间")
    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    @Length(min = 1, max = 150, message = "照片长度必须介于 1 和 150 之间")
    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getReviewState() {
        return reviewState;
    }

    public void setReviewState(String reviewState) {
        this.reviewState = reviewState;
    }

    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    @Length(min = 1, max = 2000, message = "内容长度必须介于 1 和 2000 之间")
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    private String lostAndFoundCodeLike;        // 寻宠寻主编号模糊查询
    private String identificationFlagLike;        // 芯片号模糊查询
    private String cityLike;        // 城市模糊查询

    public String getLostAndFoundCodeLike() {
        return lostAndFoundCodeLike;
    }

    public void setLostAndFoundCodeLike(String lostAndFoundCodeLike) {
        this.lostAndFoundCodeLike = lostAndFoundCodeLike;
    }

    public String getIdentificationFlagLike() {
        return identificationFlagLike;
    }

    public void setIdentificationFlagLike(String identificationFlagLike) {
        this.identificationFlagLike = identificationFlagLike;
    }

    public String getCityLike() {
        return cityLike;
    }

    public void setCityLike(String cityLike) {
        this.cityLike = cityLike;
    }
}