package com.cab.passport.marketing.service;


import com.cab.passport.marketing.dao.DogAppriaisalDao;
import com.cab.passport.marketing.entity.DogAppraisal;
import com.cab.passport.sys.payment.dao.PaymentOrderDao;
import com.cab.passport.sys.payment.dao.PaymentOrderDetailDao;
import com.cab.passport.sys.payment.dao.PaymentRecordDao;
import com.cab.passport.sys.payment.entity.PaymentChargingItem;
import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.cab.passport.sys.payment.entity.PaymentOrderDetail;
import com.cab.passport.sys.payment.service.PaymentChargingItemService;
import com.cab.passport.sys.payment.service.PaymentOrderService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.ZAException;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
@Service
@Transactional(readOnly = true)
public class DogAppraisalService  {

    @Autowired
    private DogAppriaisalDao dogAppriaisalDao;
    @Autowired
    PaymentChargingItemService paymentChargingItemService;
    @Autowired
    PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    PaymentOrderDao paymentOrderDao;
    @Autowired
    PaymentRecordDao paymentRecordDao;
    @Autowired
    PaymentOrderService paymentOrderService;

    private static final String DOG_APPRAISAL_FEE = "dog_appraisal@all";
    private static final String CAT_APPRAISAL_FEE = "dog_appraisal@cat";


    @Transactional(readOnly = false)
    public RESTResponse saveDogAppraisal() {
        return new RESTResponse();
    }

    private PaymentOrder buildPaymentOrder(DogAppraisal dogAppraisal){
        PaymentOrder order = new PaymentOrder();
        order.setMemberCode(dogAppraisal.getMemberCode());
        order.setMemberName(dogAppraisal.getDogOwnerName());
        order.setAddTime(new Date());
        order.setSource("weixin");
        order.setPaymentWay("24");
        order.setReceiveAddress(dogAppraisal.getAddress());
        order.setReceiveArea(dogAppraisal.getArea());
        order.setReceiveCity(dogAppraisal.getCity());
        order.setReceiveProvince(dogAppraisal.getProvince());
        order.setReceiver(dogAppraisal.getDogOwnerName());
        order.setReceiveDel(dogAppraisal.getMobile());
        return order;
    }

    @Transactional(readOnly = false)
    private List<PaymentOrderDetail> buildPaymentOrderDetailList(PaymentOrder paymentOrder, DogAppraisal dogAppraisal){

        List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
        if(dogAppraisal==null){
            throw new ZAException("犬只鉴定记录有误!");
        }else{
            PaymentChargingItem paymentChargingItem = new PaymentChargingItem();
            if(StringUtils.isNotBlank(dogAppraisal.getType()) && "2".equals(dogAppraisal.getType())){
                paymentChargingItem = paymentChargingItemService.getByShortName(DOG_APPRAISAL_FEE);
            }else{
                paymentChargingItem = paymentChargingItemService.getByShortName(CAT_APPRAISAL_FEE);
            }
            PaymentOrderDetail detail = new PaymentOrderDetail();
            detail.setAddTime(paymentOrder.getAddTime());
            detail.setProccessState("0");
            detail.setTotalPrice(paymentChargingItem.getPrice());
            detail.setNum("1");
            detail.setPrice(paymentChargingItem.getPrice());
            detail.setBusinessTable("dog_appraisal");
            detail.setChargingItemId(paymentChargingItem.getId());
            detail.setMemberCode(paymentOrder.getMemberCode());
            detail.setMemberName(paymentOrder.getMemberName());
            detail.setChargingItemName(paymentChargingItem.getName());
            detail.setBusinessIds(dogAppraisal.getId().trim());
            paymentOrderDetailList.add(detail);
        }
        return paymentOrderDetailList;
    }

    @Transactional(readOnly = false)
    public PaymentOrder addToOrder(DogAppraisal dogAppraisal) {
        //设置订单基本字段
        PaymentOrder paymentOrder = buildPaymentOrder(dogAppraisal);
        //构造订单详情列表
        List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder,dogAppraisal);
        //计算订单总额
        Double orderTotal = 0d;
        for(PaymentOrderDetail detail:paymentOrderDetailList){
            orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
        }
        //保存订单
        paymentOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
        //回写订单详情的OrderCode字段
        for(PaymentOrderDetail detail:paymentOrderDetailList){
            detail.setOrderCode(paymentOrder.getOrderCode());
        }
        //保存订单详情
        for(PaymentOrderDetail detail:paymentOrderDetailList){
            detail.preInsert();
            paymentOrderDetailDao.insert(detail);
        }
        //更新业务表流水号
        for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
            //更新业务表不为空且不为会员表的收费项
            String businessIds = paymentOrderDetail.getBusinessIds();
            if(businessIds.contains(",")){
                String[] bids = businessIds.split(",");
                for(int j=0;j<bids.length;j++){
                    paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
                }
            }else{
                paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
            }
        }
        return paymentOrder;
    }

    /**
     *
     * @param json
     * @param request
     * @param type 类型猫1 狗2
     * @return
     */
        @Transactional(readOnly = false)
        public RESTResponse saveDogAppraisal(String json, HttpServletRequest request,String type) {
            // 获取参数
            JSONObject jo = JSONObject.fromObject(json);
            //参数校验
            validateParameter(jo,type);
            //实例化
            DogAppraisal dogAppraisal = buildDogAppraisal(jo,type);
            dogAppriaisalDao.saveDogAppraisal(dogAppraisal);
            PaymentOrder paymentOrder = addToOrder(dogAppraisal);
            JSONObject data = new JSONObject();
            data.put("orderId", paymentOrder.getId());
            data.put("price", paymentOrder.getTotalPrice());
            return new RESTResponse("data", data);
        }

        private void validateParameter(JSONObject jo,String type) {
            String typeName = type.equals("2")?"狗":"猫";
            if (!jo.containsKey("referee") || StringUtils.isBlank(jo.getString("referee"))) {
                throw new ZAException("推荐人不能为空");
            }
            if (!jo.containsKey("dogOwnerName") || StringUtils.isBlank(jo.getString("dogOwnerName"))) {
                throw new ZAException(typeName+"主姓名不能为空");
            }
            if (!jo.containsKey("mobile") || StringUtils.isBlank(jo.getString("mobile"))) {
                throw new ZAException("手机号不能为空");
            }
            if (!jo.containsKey("province") || StringUtils.isBlank(jo.getString("province"))) {
                throw new ZAException("省份不能为空");
            }
            if (!jo.containsKey("city") || StringUtils.isBlank(jo.getString("city"))) {
                throw new ZAException("城市不能为空");
            }
            if (!jo.containsKey("area") || StringUtils.isBlank(jo.getString("area"))) {
                throw new ZAException("区域不能为空");
            }
            if (!jo.containsKey("address") || StringUtils.isBlank(jo.getString("address"))) {
                throw new ZAException("详细的地址不能为空");
            }
            if (!jo.containsKey("dogBreed") || StringUtils.isBlank(jo.getString("dogBreed"))) {
                throw new ZAException(typeName+"种类不能为空");
            }
            if (!jo.containsKey("dogColor") || StringUtils.isBlank(jo.getString("dogColor"))) {
                throw new ZAException(typeName+"只颜色不能为空");
            }
            if (!jo.containsKey("dogGender") || StringUtils.isBlank(jo.getString("dogGender"))) {
                throw new ZAException(typeName+"只性别不能为空");
            }
            if (!jo.containsKey("dogName") || StringUtils.isBlank(jo.getString("dogName"))) {
                throw new ZAException(typeName+"只名不能为空");
            }
            if (!jo.containsKey("dogBirthdate") || StringUtils.isBlank(jo.getString("dogBirthdate"))) {
                throw new ZAException(typeName+"只出生日期不能为空");
            }
            if(type.equals("2")){
                if (!jo.containsKey("cardNo") || StringUtils.isBlank(jo.getString("cardNo"))) {
                    throw new ZAException("证件号不能为空");
                }
                if (!jo.containsKey("gender") || StringUtils.isBlank(jo.getString("gender"))) {
                    throw new ZAException("性别不能为空");
                }
                //报名鉴定犬只最小年龄为6个月
                try {
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                    Date dogBirthdayDate =  sd.parse(jo.getString("dogBirthdate"));
                    Calendar cal = Calendar.getInstance();
                    cal.add(Calendar.MONTH, -6);
                    String time = sd.format(cal.getTime());
                    if(dogBirthdayDate.after(sd.parse(time))){
                        throw new ZAException("报名鉴定"+typeName+"只最小年龄为6个月");
                    }
                } catch (ParseException e) {
                    throw new ZAException("日期格式不正确");
                }
                if (!jo.containsKey("frontPic") || StringUtils.isBlank(jo.getString("frontPic"))) {
                    throw new ZAException("正面照片不能为空");
                }
                if (!jo.containsKey("leftSidePic") || StringUtils.isBlank(jo.getString("leftSidePic"))) {
                    throw new ZAException("左侧面照片不能为空");
                }
                if (!jo.containsKey("rightSidePic") || StringUtils.isBlank(jo.getString("rightSidePic"))) {
                    throw new ZAException("右侧面照片不能为空");
                }
                if (!jo.containsKey("backPic") || StringUtils.isBlank(jo.getString("backPic"))) {
                    throw new ZAException("背面照片不能为空");
                }
                if (!jo.containsKey("runVideo") || StringUtils.isBlank(jo.getString("runVideo"))) {
                    throw new ZAException("视频不能为空");
                }
                if (!jo.containsKey("noseVideo") || StringUtils.isBlank(jo.getString("noseVideo"))) {
                    throw new ZAException("视频不能为空");
                }
            }else{
                if (!jo.containsKey("wxcard") || StringUtils.isBlank(jo.getString("wxcard"))) {
                    throw new ZAException("微信号不能为空");
                }
                //报名鉴定猫只最小年龄为3个月
                try {
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                    Date dogBirthdayDate =  sd.parse(jo.getString("dogBirthdate"));
                    Calendar cal = Calendar.getInstance();
                    cal.add(Calendar.MONTH, -3);
                    String time = sd.format(cal.getTime());
                    if(dogBirthdayDate.after(sd.parse(time))){
                        throw new ZAException("报名鉴定"+typeName+"只最小年龄为3个月");
                    }
                } catch (ParseException e) {
                    throw new ZAException("日期格式不正确");
                }
                if (!jo.containsKey("image1") || StringUtils.isBlank(jo.getString("image1"))) {
                    throw new ZAException("头部-正面");
                }
                if (!jo.containsKey("image2") || StringUtils.isBlank(jo.getString("image2"))) {
                    throw new ZAException("头部-侧面");
                }
                if (!jo.containsKey("image3") || StringUtils.isBlank(jo.getString("image3"))) {
                    throw new ZAException("头部-额顶");
                }
                if (!jo.containsKey("image4") || StringUtils.isBlank(jo.getString("image4"))) {
                    throw new ZAException("头部-牙齿");
                }
                if (!jo.containsKey("image5") || StringUtils.isBlank(jo.getString("image5"))) {
                    throw new ZAException("身体-正面");
                }
                if (!jo.containsKey("image6") || StringUtils.isBlank(jo.getString("image6"))) {
                    throw new ZAException("身体-侧面");
                }
                if (!jo.containsKey("image7") || StringUtils.isBlank(jo.getString("image7"))) {
                    throw new ZAException("身体-前爪垫");
                }
                if (!jo.containsKey("image8") || StringUtils.isBlank(jo.getString("image8"))) {
                    throw new ZAException("身体-后爪垫");
                }
                if (!jo.containsKey("image9") || StringUtils.isBlank(jo.getString("image9"))) {
                    throw new ZAException("身体-尾巴");
                }
                if (!jo.containsKey("image10") || StringUtils.isBlank(jo.getString("image10"))) {
                    throw new ZAException("身体-腹部");
                }
                if (!jo.containsKey("image11") || StringUtils.isBlank(jo.getString("image11"))) {
                    throw new ZAException("毛发-背部");
                }
                if (!jo.containsKey("image12") || StringUtils.isBlank(jo.getString("image12"))) {
                    throw new ZAException("毛发-毛质");
                }
            }
        }
        private DogAppraisal buildDogAppraisal(JSONObject jo,String type) {
            DogAppraisal dogAppraisal = new DogAppraisal();
            dogAppraisal.preInsert();
            dogAppraisal.setType(type);
            dogAppraisal.setReferee(jo.getString("referee"));
            dogAppraisal.setDogOwnerName(jo.getString("dogOwnerName"));
            dogAppraisal.setMobile(jo.getString("mobile"));

            if (jo.containsKey("memberCode") && StringUtils.isNotBlank(jo.getString("memberCode"))) {
                dogAppraisal.setMemberCode(jo.getString("memberCode"));
            }
            dogAppraisal.setProvince(jo.getString("province"));
            dogAppraisal.setCity(jo.getString("city"));
            dogAppraisal.setArea(jo.getString("area"));
            dogAppraisal.setAddress(jo.getString("address"));
            dogAppraisal.setDogBreed(jo.getString("dogBreed"));
            dogAppraisal.setDogColor(jo.getString("dogColor"));
            dogAppraisal.setDogGender(jo.getString("dogGender"));
            dogAppraisal.setDogName(jo.getString("dogName"));
            try {
                Date dogBirthdayDate =  new SimpleDateFormat("yyyy-MM-dd").parse(jo.getString("dogBirthdate"));
                dogAppraisal.setDogBirthdate(dogBirthdayDate);
            } catch (ParseException e) {
                throw new ZAException("日期格式不正确");
            }
            if(type.equals("2")){
                dogAppraisal.setCardNo(jo.getString("cardNo"));
                dogAppraisal.setGender(jo.getString("gender"));
                dogAppraisal.setFrontPic(jo.getString("frontPic"));
                dogAppraisal.setLeftSidePic(jo.getString("leftSidePic"));
                dogAppraisal.setRightSidePic(jo.getString("rightSidePic"));
                dogAppraisal.setBackPic(jo.getString("backPic"));
                dogAppraisal.setRunVideo(jo.getString("runVideo"));
                dogAppraisal.setNoseVideo(jo.getString("noseVideo"));
            }else{
                dogAppraisal.setWxcard(jo.getString("wxcard"));
                dogAppraisal.setImage1(jo.getString("image1"));
                dogAppraisal.setImage2(jo.getString("image2"));
                dogAppraisal.setImage3(jo.getString("image3"));
                dogAppraisal.setImage4(jo.getString("image4"));
                dogAppraisal.setImage5(jo.getString("image5"));
                dogAppraisal.setImage6(jo.getString("image6"));
                dogAppraisal.setImage7(jo.getString("image7"));
                dogAppraisal.setImage8(jo.getString("image8"));
                dogAppraisal.setImage9(jo.getString("image9"));
                dogAppraisal.setImage10(jo.getString("image10"));
                dogAppraisal.setImage11(jo.getString("image11"));
                dogAppraisal.setImage12(jo.getString("image12"));
            }
            dogAppraisal.setPaymentState("1");
            return  dogAppraisal;
        }

}

