package com.cab.passport.marketing.pub.web;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.alibaba.fastjson.JSON;
import com.cab.passport.marketing.service.CatConfig;
import com.cab.passport.marketing.service.MyCatWXPayConfig;
import com.cab.passport.marketing.service.MyWXPayConfig;
import com.cab.passport.marketing.service.WXpayServiceImpl;
import com.github.wxpay.sdk.WXPay;
import com.github.wxpay.sdk.WXPayConfig;
import com.github.wxpay.sdk.WXPayUtil;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;

@RestController
public class WXpayPayController extends BaseController {

	@Autowired
	private WXpayServiceImpl wxpayServiceImpl;

	@Autowired
	private MyWXPayConfig wxPayConfig;
	
	@Autowired
	private CatConfig catConfig;

	@Autowired
	private MyCatWXPayConfig catWxPayConfig;

	/**
	 * 先通过code来获取AccessToken
	 * 
	 * @param code
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/jbhd/getAccessToken")
	@ResponseBody
	public RESTResponse getAccessToken(@RequestBody String json, HttpServletRequest request) throws Exception {
		Map<String, String> map = null;
		try {
			HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
			String code = mapP.get("code");
			map = wxpayServiceImpl.getAccessToken(code, "dog");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}
		return new RESTResponse("openid", map.get("openid"));
	}

	/**
	 * 先通过code来获取AccessToken
	 * 
	 * @param code
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/jbhd/cat/getAccessToken")
	@ResponseBody
	public RESTResponse getCatAccessToken(@RequestBody String json, HttpServletRequest request) throws Exception {
		Map<String, String> map = null;
		try {
			HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
			String code = mapP.get("code");
			map = wxpayServiceImpl.getAccessToken(code, "cat");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}
		return new RESTResponse("openid", map.get("openid"));
	}

	/**
	 * 先通过code来获取AccessToken，再用AccessToken获取票据，票据获取成功后签名给前台，用来拉起支付
	 * 
	 * @param code
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/jbhd/getTicket")
	@ResponseBody
	public RESTResponse getTicket(@RequestBody String json, HttpServletRequest request) throws Exception {
		HashMap<String, String> map = JSON.parseObject(json, HashMap.class);
		String url = map.get("url");
		try {
			return new RESTResponse(wxpayServiceImpl.getTicket(url, "dog"));
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}

	}

	@RequestMapping("/jbhd/cat/getTicket")
	@ResponseBody
	public RESTResponse getCatTicket(@RequestBody String json, HttpServletRequest request) throws Exception {
		HashMap<String, String> map = JSON.parseObject(json, HashMap.class);
		String url = map.get("url");
		try {
			return new RESTResponse(wxpayServiceImpl.getTicket(url, "cat"));
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}

	}

	// 新建微信付款单
	@RequestMapping("WXPay/create")
	@ResponseBody
	public RESTResponse createPayOrder(@RequestBody String json, HttpServletRequest request) throws Exception {
		HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
		String orderId = mapP.get("orderId");
		String openId = mapP.get("openId");
		String userIp = getIpAddress(request);
		try {
			return wxpayServiceImpl.createPayOrder(orderId, userIp, openId, "dog");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}
	}

	// 新建微信付款单
	@RequestMapping("WXPay/cat/create")
	@ResponseBody
	public RESTResponse createCatPayOrder(@RequestBody String json, HttpServletRequest request) throws Exception {
		HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
		String orderId = mapP.get("orderId");
		String openId = mapP.get("openId");
		String userIp = getIpAddress(request);
		try {
			return wxpayServiceImpl.createPayOrder(orderId, userIp, openId, "cat");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return new RESTResponse(10001, e.getMessage());
		}
	}

	/**
	 * 获取真实ip地址，避免获取代理ip
	 * 
	 * @throws UnknownHostException
	 */
	public String getIpAddress(HttpServletRequest request) throws UnknownHostException {

		String ip = request.getRemoteAddr();
		if (StringUtils.isBlank(ip)) {
			ip = "0:0:0:0:0:0:0:1";
		}

		// String ip = request.getHeader("x-forwarded-for");
		// if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
		// ip = request.getHeader("Proxy-Client-IP");
		// }
		// if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
		// ip = request.getHeader("WL-Proxy-Client-IP");
		// }
		// if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
		// ip = request.getHeader("HTTP_CLIENT_IP");
		// }
		// if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
		// ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		// }
		// if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
		// ip = request.getRemoteAddr();
		// }
		// if (StringUtils.isBlank(ip)) {
		// ip = InetAddress.getLocalHost().getHostAddress();
		// }
		return ip;
	}

	// 查询付款结果
	@RequestMapping("WXPay/check")
	public RESTResponse check(@RequestBody String json) throws Exception {
		logger.debug("~~~~~~~~~~~~~~~~dog前端调用1~~~~~~~~~" + json);
		HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
		String payLogId = mapP.get("payLogId");
		RESTResponse response = wxpayServiceImpl.check(payLogId, "dog");
		logger.debug("~~~~~~~~~~~~~~~~前端调用2~~~~~~~~~" + response);
		return response;
	}

	// 查询付款结果
	@RequestMapping("WXPay/cat/check")
	public RESTResponse catCheck(@RequestBody String json) throws Exception {
		logger.debug("~~~~~~~~~~~~~~~~cat前端调用1~~~~~~~~~" + json);
		HashMap<String, String> mapP = JSON.parseObject(json, HashMap.class);
		String payLogId = mapP.get("payLogId");
		RESTResponse response = wxpayServiceImpl.check(payLogId, "cat");
		logger.debug("~~~~~~~~~~~~~~~~前端调用2~~~~~~~~~" + response);
		return response;
	}

	@RequestMapping("wxpay/notify")
	public void wxpayNotify() throws Exception {
		logger.debug("~~~~~~~~~~~~~~~~dog处理微信付款成功通知~~~~~~~~~");
		ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder
				.getRequestAttributes();
		InputStream inStream = requestAttributes.getRequest().getInputStream();
		ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
		byte[] buffer = new byte[1024];
		int len = 0;
		while ((len = inStream.read(buffer)) != -1) {
			outSteam.write(buffer, 0, len);
		}
		outSteam.close();
		inStream.close();
		byte[] b = outSteam.toByteArray();
		Map<String, String> result = WXPayUtil.xmlToMap(new String(b, StandardCharsets.UTF_8));
		if ("SUCCESS".equals(result.get("return_code")) && "SUCCESS".equals(result.get("result_code"))) {
			WXPay wxpay = new WXPay(getConfig("dog"));
			if (wxpay.isPayResultNotifySignatureValid(result)) {
				logger.debug("~~~~~~~~~~~~~~~~成功接收微信支付成功通知,商户订单号{}~~~~~~~~~", result.get("out_trade_no"));
				logger.debug("@@@@@@@微信返回报文：{}", result);

				Boolean flag = this.wxpayServiceImpl.paySuccess(result);
				logger.debug("@@@@@@@是否成功：", flag);
				Map<String, String> data = new HashMap<>(2);
				if (flag) {
					data.put("return_code", "SUCCESS");
					data.put("return_msg", "OK");
				} else {
					data.put("return_code", "FAIL");
				}
				requestAttributes.getResponse().getWriter().write(WXPayUtil.mapToXml(data));
			}
		} else {
			logger.error("~~~~~~~~~~~~~~~~微信签名验证失败~~~~~~~~result~{}", result);
		}
	}

	@RequestMapping("wxpay/cat/notify")
	public void wxpayCatNotify() throws Exception {
		logger.debug("~~~~~~~~~~~~~~~~cat处理微信付款成功通知~~~~~~~~~");
		ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder
				.getRequestAttributes();
		InputStream inStream = requestAttributes.getRequest().getInputStream();
		ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
		byte[] buffer = new byte[1024];
		int len = 0;
		while ((len = inStream.read(buffer)) != -1) {
			outSteam.write(buffer, 0, len);
		}
		outSteam.close();
		inStream.close();
		byte[] b = outSteam.toByteArray();
		Map<String, String> result = WXPayUtil.xmlToMap(new String(b, StandardCharsets.UTF_8));
		if ("SUCCESS".equals(result.get("return_code")) && "SUCCESS".equals(result.get("result_code"))) {
			WXPay wxpay = new WXPay(catConfig);
			if (wxpay.isPayResultNotifySignatureValid(result)) {
				logger.debug("~~~~~~~~~~~~~~~~成功接收微信支付成功通知,商户订单号{}~~~~~~~~~", result.get("out_trade_no"));
				logger.debug("@@@@@@@微信返回报文：{}", result);

				Boolean flag = this.wxpayServiceImpl.paySuccess(result);
				logger.debug("@@@@@@@是否成功:{}", flag);
				Map<String, String> data = new HashMap<>(2);
				if (flag) {
					data.put("return_code", "SUCCESS");
					data.put("return_msg", "OK");
				} else {
					data.put("return_code", "FAIL");
				}
				requestAttributes.getResponse().getWriter().write(WXPayUtil.mapToXml(data));
			}
		} else {
			logger.error("~~~~~~~~~~~~~~~~微信签名验证失败~~~~~~~~result~{}", result);
		}
	}

	private WXPayConfig getConfig(String type) {
		WXPayConfig config = null;
		switch (type) {
		case "cat":
			config = catWxPayConfig;
			break;
		case "dog":
			config = wxPayConfig;
			break;
		default:
			config = wxPayConfig;
			break;
		}
		return config;
	}

}
