/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.dao;

import com.cab.passport.passportorder.entity.PassportOrder;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 护照订单DAO接口
 *
 * @author lgl
 * @version 2018-10-09
 */
@MyBatisDao
public interface PassportOrderDao extends CrudDao<PassportOrder> {
    String getMaxCabPassportByLastSeven(@Param("lastSeven") String lastSeven);

    PassportOrder getByIdentificationFlagAndConsigneePhone(@Param("identificationFlag") String identificationFlag,
                                                           @Param("consigneePhone") String consigneePhone);

    PassportOrder getByIdentificationFlag(@Param("identificationFlag") String identificationFlag);

    PassportOrder getByCabPassport(@Param("cabPassport") String cabPassport);


    List<PassportOrder> getByIdList(Map map);
}