/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petstore.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 宠物店Entity
 *
 * @author lgl
 * @version 2018-12-18
 */
public class PetStore extends DataEntity<PetStore> {

    private static final long serialVersionUID = 1L;
    private String channelUserId;        // 渠道用户id
    @ExcelField(title = "激活码", align = 2, sort = 0)
    private String inviteCode;        // 邀请码
    private Date activationTime;        // 激活时间
    @ExcelField(title = "微信", align = 2, sort = 3)
    private String wxOpenId;        // 微信openId
    @ExcelField(title = "姓名", align = 2, sort = 1)
    private String petStoreOwnerName;        // 姓名
    @ExcelField(title = "手机号", align = 2, sort = 2)
    private String petStoreOwnerMobile;        // 手机号
    @ExcelField(title = "宠物店名称", align = 2, sort = 4)
    private String petStoreName;        // 宠物店名称
    @ExcelField(title = "宠物店所在城市", align = 2, sort = 5)
    private String petStoreCity;        // 宠物店所在城市
    @ExcelField(title = "宠物店地址", align = 2, sort = 6)
    private String petStoreAddress;        // 宠物店地址
    @ExcelField(title = "宠物店联系方式", align = 2, sort = 8)
    private String petStoreMobile;        // 宠物店联系方式
    @ExcelField(title = "宠物店面积", align = 2, sort = 9)
    private String petStoreArea;        // 宠物店面积
    @ExcelField(title = "主营项目", align = 2, sort = 10)
    private String mainProject;        // 主营项目:1美容;2洗澡;3寄养;4用品
    @ExcelField(title = "是否有CKU认证的美容师/训练师", align = 2, sort = 11)
    private String ckuGroomerTrainerFlag;        // 是否有CKU认证的美容师/训练师:0否;1是
    private String sellPetFlag;        // 是否销售活体:0否;1是
    private String consign;            //是否寄售：0否;1是
    private String sellDogType;        // 销售犬品种
    private String sellCatType;        // 销售猫品种
    private String yearlySalesVolume;        // 年销量:1一到三只;2三到五只;3五只以上
    @ExcelField(title = "营业执照号", align = 2, sort = 7)
    private String businessLicenseNumber;        // 营业执照号
    private String provinceIds;        // 可查看省的id,直辖市多个,逗号分隔
    private String refererCode;     // 推荐码
    private String refererName;    //推广人姓名

    public PetStore() {
        super();
    }

    public PetStore(String id) {
        super(id);
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Length(min = 1, max = 100, message = "渠道用户id长度必须介于 1 和 20 之间")
    public String getChannelUserId() {
        return channelUserId;
    }

    public void setChannelUserId(String channelUserId) {
        this.channelUserId = channelUserId;
    }

    @Length(min = 1, max = 20, message = "邀请码长度必须介于 1 和 20 之间")
    public String getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getActivationTime() {
        return activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    @Length(min = 1, max = 50, message = "微信openId长度必须介于 1 和 50 之间")
    public String getWxOpenId() {
        return wxOpenId;
    }

    public void setWxOpenId(String wxOpenId) {
        this.wxOpenId = wxOpenId;
    }

    @Length(min = 1, max = 20, message = "姓名长度必须介于 1 和 20 之间")
    public String getPetStoreOwnerName() {
        return petStoreOwnerName;
    }

    public void setPetStoreOwnerName(String petStoreOwnerName) {
        this.petStoreOwnerName = petStoreOwnerName;
    }

    @Length(min = 1, max = 20, message = "手机号长度必须介于 1 和 20 之间")
    public String getPetStoreOwnerMobile() {
        return petStoreOwnerMobile;
    }

    public void setPetStoreOwnerMobile(String petStoreOwnerMobile) {
        this.petStoreOwnerMobile = petStoreOwnerMobile;
    }

    @Length(min = 1, max = 100, message = "宠物店名称长度必须介于 1 和 100 之间")
    public String getPetStoreName() {
        return petStoreName;
    }

    public void setPetStoreName(String petStoreName) {
        this.petStoreName = petStoreName;
    }

    @Length(min = 1, max = 50, message = "宠物店所在城市长度必须介于 1 和 50 之间")
    public String getPetStoreCity() {
        return petStoreCity;
    }

    public void setPetStoreCity(String petStoreCity) {
        this.petStoreCity = petStoreCity;
    }

    @Length(min = 1, max = 300, message = "宠物店地址长度必须介于 1 和 300 之间")
    public String getPetStoreAddress() {
        return petStoreAddress;
    }

    public void setPetStoreAddress(String petStoreAddress) {
        this.petStoreAddress = petStoreAddress;
    }

    public String getPetStoreMobile() {
        return petStoreMobile;
    }

    public void setPetStoreMobile(String petStoreMobile) {
        this.petStoreMobile = petStoreMobile;
    }

    public String getPetStoreArea() {
        return petStoreArea;
    }

    public void setPetStoreArea(String petStoreArea) {
        this.petStoreArea = petStoreArea;
    }

    public String getMainProject() {
        return mainProject;
    }

    public void setMainProject(String mainProject) {
        this.mainProject = mainProject;
    }

    public String getCkuGroomerTrainerFlag() {
        return ckuGroomerTrainerFlag;
    }

    public void setCkuGroomerTrainerFlag(String ckuGroomerTrainerFlag) {
        this.ckuGroomerTrainerFlag = ckuGroomerTrainerFlag;
    }

    public String getSellPetFlag() {
        return sellPetFlag;
    }

    public void setSellPetFlag(String sellPetFlag) {
        this.sellPetFlag = sellPetFlag;
    }

    public String getConsign() {
        return consign;
    }

    public void setConsign(String consign) {
        this.consign = consign;
    }

    public String getSellDogType() {
        return sellDogType;
    }

    public void setSellDogType(String sellDogType) {
        this.sellDogType = sellDogType;
    }

    public String getSellCatType() {
        return sellCatType;
    }

    public void setSellCatType(String sellCatType) {
        this.sellCatType = sellCatType;
    }

    public String getYearlySalesVolume() {
        return yearlySalesVolume;
    }

    public void setYearlySalesVolume(String yearlySalesVolume) {
        this.yearlySalesVolume = yearlySalesVolume;
    }

    @Length(min = 1, max = 100, message = "营业执照号长度必须介于 1 和 100 之间")
    public String getBusinessLicenseNumber() {
        return businessLicenseNumber;
    }

    public void setBusinessLicenseNumber(String businessLicenseNumber) {
        this.businessLicenseNumber = businessLicenseNumber;
    }

    @Length(min = 1, max = 20, message = "可查看省的id,直辖市多个,逗号分隔长度必须介于 1 和 20 之间")
    public String getProvinceIds() {
        return provinceIds;
    }

    public void setProvinceIds(String provinceIds) {
        this.provinceIds = provinceIds;
    }

    private String petStoreOwnerNameLike;
    private String petStoreOwnerMobileLike;
    private String petStoreNameLike;
    private String petStoreCityLike;
    private String inviteCodeLike;
    private Date activationTimeStart;
    private Date activationTimeEnd;

    public String getPetStoreOwnerNameLike() {
        return petStoreOwnerNameLike;
    }

    public void setPetStoreOwnerNameLike(String petStoreOwnerNameLike) {
        this.petStoreOwnerNameLike = petStoreOwnerNameLike;
    }

    public String getPetStoreOwnerMobileLike() {
        return petStoreOwnerMobileLike;
    }

    public void setPetStoreOwnerMobileLike(String petStoreOwnerMobileLike) {
        this.petStoreOwnerMobileLike = petStoreOwnerMobileLike;
    }

    public String getPetStoreNameLike() {
        return petStoreNameLike;
    }

    public void setPetStoreNameLike(String petStoreNameLike) {
        this.petStoreNameLike = petStoreNameLike;
    }

    public String getPetStoreCityLike() {
        return petStoreCityLike;
    }

    public void setPetStoreCityLike(String petStoreCityLike) {
        this.petStoreCityLike = petStoreCityLike;
    }

    public String getInviteCodeLike() {
        return inviteCodeLike;
    }

    public void setInviteCodeLike(String inviteCodeLike) {
        this.inviteCodeLike = inviteCodeLike;
    }

    public Date getActivationTimeStart() {
        return activationTimeStart;
    }

    public void setActivationTimeStart(Date activationTimeStart) {
        this.activationTimeStart = activationTimeStart;
    }

    public Date getActivationTimeEnd() {
        return activationTimeEnd;
    }

    public void setActivationTimeEnd(Date activationTimeEnd) {
        this.activationTimeEnd = activationTimeEnd;
    }

    //联系犬舍次数,操作4
    @ExcelField(title = "联系犬舍次数", align = 2, sort = 12)
    private long contactPetOwnerCount;
    //展示页面登录次数,操作1+2
    @ExcelField(title = "展示页面登录次数", align = 2, sort = 13)
    private long viewPetOwnerCount;
    //联系该宠物店次数,操作3
    @ExcelField(title = "联系该宠物店次数", align = 2, sort = 14)
    private long contactPetStoreCount;

    public long getContactPetOwnerCount() {
        return contactPetOwnerCount;
    }

    public void setContactPetOwnerCount(long contactPetOwnerCount) {
        this.contactPetOwnerCount = contactPetOwnerCount;
    }

    public long getViewPetOwnerCount() {
        return viewPetOwnerCount;
    }

    public void setViewPetOwnerCount(long viewPetOwnerCount) {
        this.viewPetOwnerCount = viewPetOwnerCount;
    }

    public long getContactPetStoreCount() {
        return contactPetStoreCount;
    }

    public void setContactPetStoreCount(long contactPetStoreCount) {
        this.contactPetStoreCount = contactPetStoreCount;
    }

    public String getRefererCode() {
        return refererCode;
    }

    public void setRefererCode(String refererCode) {
        this.refererCode = refererCode;
    }

    public String getRefererName() {
        return refererName;
    }

    public void setRefererName(String refererName) {
        this.refererName = refererName;
    }
}