package com.thinkgem.jeesite.modules.sys.web;

import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.BaseFile;
import com.thinkgem.jeesite.modules.sys.service.FileService;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;

@Controller
@RequestMapping("${adminPath}/pub/file")
public class FileController extends BaseController {
    @Autowired
    private FileService fileService;

    @RequestMapping(value = "image/{id}")
    public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
        BaseFile file = fileService.get(id);
        FileInputStream fis = new FileInputStream(FileService.fileDir + File.separator + file.getLocation() + File.separator + file.getName());
        response.setContentType("image/png");
        byte[] b = new byte[fis.available()];
        IOUtils.read(fis, b);
        fis.close();
        IOUtils.write(b, response.getOutputStream());
    }

    @RequestMapping(value = "petLostAndFound", method = RequestMethod.POST)
    @ResponseBody
    public Object petLostAndFound(MultipartFile file) throws IOException {
        BaseFile baseFile = fileService.watermarkImg(file, "petLostAndFound", "1");
        JSONObject data = new JSONObject();
        data.put("fileName", baseFile.getName());
        data.put("id", baseFile.getId());
        return new RESTResponse(data);
    }
    /**
     * 赛事layer 上传图片
     *
     * @Author chaixueteng
     * @2017年8月7日上午10:01:14
     */
    @RequestMapping(value = "layupload")
    @ResponseBody
    public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseFile baseFile = fileService.uploadFile(file, "advertising", "1");
        JSONObject fileObject = new JSONObject();
        fileObject.put("id", baseFile.getId());
        fileObject.put("fileName", baseFile.getName());
        fileObject.put("realName", baseFile.getOrginalname());
        String imgPath = "http://" + request.getHeader("host") + request.getContextPath() + adminPath + "/pub/file/image/" + baseFile.getId();
        fileObject.put("url", imgPath);
        response.setContentType("text/html;charset=UTF-8");//ie 浏览器使用layui 需设置头为html
        response.getWriter().write(fileObject.toString());
    }

}
