package com.thinkgem.jeesite.common.exception;

import java.util.HashMap;
import java.util.Map;

import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class ExceptionAdvice {

	@ExceptionHandler(value = MaxUploadSizeExceededException.class)
	@ResponseBody
	public Map<String, Object> maxUploadException(Exception ex) {
		Map<String, Object> map = new HashMap<>();
		map.put("rc", -1);
		map.put("smg", "视频已超出最大限制");
		return map;
	}
	

//	@ExceptionHandler(value = MultipartException.class)
//	@ResponseBody
//	public Map<String, Object> multipartException(Exception ex) {
//		Map<String, Object> map = new HashMap<>();	
//		map.put("rc", -1);
//		map.put("smg", "文件上传失败");
//		return map;
//	}
	
}
