/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petstore.dao;

import com.cab.passport.petstore.entity.PetStore;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 宠物店DAO接口
 *
 * @author lgl
 * @version 2018-12-18
 */
@MyBatisDao
public interface PetStoreDao extends CrudDao<PetStore> {
    PetStore getByWxOpenId(@Param("wxOpenId") String wxOpenId);
    PetStore getByInviteCode(@Param("inviteCode") String inviteCode);
    PetStore getByChannelUserId(@Param("channelUserId") String channelUserId);
    int addPetStoreVisitLog(@Param("requestUri") String requestUri,
                            @Param("wxOpenId") String wxOpenId,
                            @Param("petStoreId") String petStoreId,
                            @Param("dogIdentificationFlag") String dogIdentificationFlag);
    List<Map<String, Object>> getVisitLogByWxOpenId(@Param("wxOpenId") String wxOpenId);
}