<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>宠物信息验证</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    var result = confirm("您确认提交吗？");
                    if (result == true) {
                        loading('正在提交，请稍等...');
                        form.submit();
                    } else {
                        return;
                    }
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li>
        <a href="${ctx}/passportOrder/club/${type}List">
            <c:if test="${type=='active'}">芯片埋置列表</c:if>
            <c:if test="${type=='certify'}">伴侣级认证列表</c:if>
        </a>
    </li>
    <li class="active">
        <a href="${ctx}/passportOrder/club/searchForm?type=${type}">
            <c:if test="${type=='active'}">埋置</c:if>
            <c:if test="${type=='certify'}">认证</c:if>
        </a>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/club/${type}" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <div class="controls">
            <c:if test="${type=='active'}">请核对护照号及身份登记内容与埋置芯片宠物是否相符。</c:if>
            <c:if test="${type=='certify'}">请由伴侣级认证师核对信息并完成伴侣级认证，认证通过请点击通过按钮。</c:if>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">护照号：</label>
        <div class="controls">
                ${passportOrder.cabPassport}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div class="controls">
                ${passportOrder.identificationFlag}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名称：</label>
        <div class="controls">
                ${passportOrder.petName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">种类：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.petType, 'pet_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">购买套餐：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
        </div>
    </div>
    <c:if test="${passportOrder.packageType==2}">
        <div class="control-group">
            <label class="control-label">伴侣级认证：</label>
            <div class="controls">
                <form:radiobuttons path="certifyResult" items="${fns:getDictList('passport_order_certify_result')}"
                                   itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
            </div>
        </div>
    </c:if>
    <div class="form-actions">
        <shiro:hasPermission name="passportOrder:club:edit"><input id="btnSubmit" class="btn btn-primary"
                                                                   type="submit"
                                                                   value="提交"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
    <div class="control-group">
        <div class="controls">
            <span class="help-inline"><font color="red">*确认无误、注射成功后 确认埋置</font> </span>
        </div>
    </div>
</form:form>
</body>
</html>