package com.cab.passport.sys.util;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;

public final class TokenUtil {
	
	private static final Log log = LogFactory.getLog(TokenUtil.class);

	public static final long DEFAULT_TIMEOUT = 2592000000L;

	public static final String ENCODE_HEADER_NAME = "token";

	// 为兼容线上TOKEN不过期，生产保留原值develop，开发测试环境变更为devtest
	private static  String ISSUER = "develop" ;

	private static final String SECRET = "ertyuiopyuiopoppom324klkjhgfghjkl";

	static {

		try {
			InputStream is = WeixinConfigUtils.class.getResourceAsStream("/jeesite.properties");
			Properties properties = new Properties();
			properties.load(is);
			ISSUER = "product".equals(properties.getProperty("mode")) ? "develop" : "devtest";

		} catch (Exception ex) {
			log.debug("加载配置文件：" + ex.getMessage());
		}
	}

	private TokenUtil() {
	}

	public static String createJwt(String subject, long ttlMillis) {
		return JWT.create().withExpiresAt(new Date(System.currentTimeMillis() + ttlMillis)).withIssuedAt(new Date())
				.withSubject(subject).withIssuer(ISSUER).sign(Algorithm.HMAC256(SECRET));
	}

	public static DecodedJWT parseJwt(String token) {
		return JWT.require(Algorithm.HMAC256(SECRET)).withIssuer(ISSUER).build().verify(token);
	}

}
