<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>天猫护照订单管理</title>
    <meta name="decorator" content="default"/>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/passportOrder/tmall">天猫护照订单管理</a></li>
    <li class="active"><a href="#">天猫护照订单详情</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/tmall/view" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">旺旺ID：</label>
        <div class="controls">
            ${fns:escapeHtml(passportOrder.wangwangId)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">订单号：</label>
        <div class="controls">
            ${fns:escapeHtml(passportOrder.tmallOrderCode)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">姓名：</label>
        <div class="controls">
            ${fns:escapeHtml(passportOrder.consigneeName)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">手机：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.consigneePhone)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">固定电话：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.consigneeLandline)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">收货地址：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.consigneeProvince)}${fns:escapeHtml(passportOrder.consigneeCity)}${fns:escapeHtml(passportOrder.consigneeDistrict)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">详细地址：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.consigneeAddress)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">下单时间：</label>
        <div class="controls">
            <fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">购买套餐信息：</label>
        <div class="controls">
            ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">重量：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.expressWeight)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名称：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.petName)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">种类：</label>
        <div class="controls">
                ${fns:getDictLabel(passportOrder.petType, 'pet_type', '')}

        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
            <c:if test="${passportOrder.petGender=='1'}">公</c:if>
            <c:if test="${passportOrder.petGender=='2'}">母</c:if>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <fmt:formatDate value="${passportOrder.petBirthday}" pattern="yyyy-MM-dd"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">毛色：</label>
        <div class="controls">
                ${fns:escapeHtml(passportOrder.petCoatColor)}
        </div>
    </div>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>