package com.cab.passport.marketing.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ServletUtils;
import com.thinkgem.jeesite.common.web.BaseController;

@Controller
@RequestMapping(value = "/pub/upload")
public class PubFileController extends BaseController {
	
	@RequestMapping(value = "/test")
	@ResponseBody
	public String test() {
		return "ok";
	}

	@RequestMapping(value = "/image/{id}")
	@ResponseBody
	public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
		super.image(id, response);
	}

	@RequestMapping(value = "/vod/{id}")
	@ResponseBody
	public void vod(@PathVariable String id, HttpServletResponse response) throws IOException {
		super.vod(id, response);
	}

	
	@RequestMapping(value = "/img")
	@ResponseBody
	public void upload(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		super.upload(file, "marketing/images", "/pub/upload/image/", request, response);
	}
	
	@RequestMapping(value = "vod")
	@ResponseBody
	public void uploadsVod(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		super.upload(file, "marketing/vod", "/pub/upload/vod/", request, response);
	}
	
	
	@RequestMapping(value = "imgs")
	@ResponseBody
	public void uploads(MultipartFile[] file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		if (file == null || file.length < 1) {
			ServletUtils.writeResponse(response, new RESTResponse("1", "上传图片不能为空"));
			return;
		}
		super.uploads(file, "marketing/images", "/pub/upload/image/", request, response);
	}

	@RequestMapping(value = "vods")
	@ResponseBody
	public void uploadsVod(MultipartFile[] file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		if (file == null || file.length < 1) {
			ServletUtils.writeResponse(response, new RESTResponse("1", "上传视频不能为空"));
		}
		super.uploads(file, "marketing/vod", "/pub/upload/vod/", request, response);
	}

}
