/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petlostandfound.service;

import com.cab.passport.petlostandfound.dao.PetLostAndFoundDao;
import com.cab.passport.petlostandfound.entity.PetLostAndFound;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.ImgUtil;
import com.thinkgem.jeesite.common.utils.PageBeanResult;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 寻宠寻主Service
 *
 * @author lgl
 * @version 2018-10-24
 */
@Service
@Transactional(readOnly = true)
public class PetLostAndFoundService extends CrudService<PetLostAndFoundDao, PetLostAndFound> {

    public PetLostAndFound get(String id) {
        return super.get(id);
    }

    public List<PetLostAndFound> findList(PetLostAndFound petLostAndFound) {
        return super.findList(petLostAndFound);
    }

    public Page<PetLostAndFound> findPage(Page<PetLostAndFound> page, PetLostAndFound petLostAndFound) {
        return super.findPage(page, petLostAndFound);
    }

    @Transactional(readOnly = false)
    public void save(PetLostAndFound petLostAndFound) {
        super.save(petLostAndFound);
    }

    @Transactional(readOnly = false)
    public void delete(PetLostAndFound petLostAndFound) {
        super.delete(petLostAndFound);
    }

    public RESTResponse get(String id, HttpServletRequest request) {
        PetLostAndFound po = dao.get(id);
        if(po == null){
            throw new ZAException("未查询到宠物");
        }
        JSONObject data = buildJo(po, request);
        return new RESTResponse(data);
    }

    public RESTResponse search(HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        String lostAndFoundType = request.getParameter("lostAndFoundType");
        String identificationFlag = request.getParameter("identificationFlag");
        PetLostAndFound example = new PetLostAndFound();
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
            if (StringUtils.isNotBlank(lostAndFoundType)) {
                example.setLostAndFoundType(Integer.valueOf(lostAndFoundType).toString());
            }
            example.setReviewState("1");
        } catch (Exception e) {
            throw new ZAException("pageNo和pageSize必须为数字！");
        }
        if (StringUtils.isNotBlank(identificationFlag)) {
            example.setIdentificationFlagLike(identificationFlag);
        }
        Page<PetLostAndFound> page = findPage(new Page<PetLostAndFound>(pageNoInt, pageSizeInt), example);
        List<JSONObject> list = new ArrayList<JSONObject>();
        for (PetLostAndFound po : page.getList()) {
            list.add(buildJo(po, request));
        }
        return new RESTResponse("list", new PageBeanResult<JSONObject>(list, page.getCount()));
    }

    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        // 获取参数
        JSONObject jo = JSONObject.fromObject(json);
        //参数校验
        postValidateParameter(jo);
        //构造实体类
        PetLostAndFound po = buildPo(jo);
        //业务校验
        if (StringUtils.isNotBlank(po.getIdentificationFlag())) {
            PetLostAndFound example = new PetLostAndFound();
            example.setIdentificationFlag(po.getIdentificationFlag());
            List<PetLostAndFound> petLostAndFoundList = dao.findList(example);
            if (petLostAndFoundList.size() > 0) {
                throw new ZAException("该芯片号已发布寻宠/寻主信息，请联系客服了解详情");
            }
        }
        //写入业务表
        po.preInsert();
        dao.insert(po);
        //返回结果
        JSONObject data = new JSONObject();
        data.put("id", po.getId());
        data.put("lostAndFoundCode", po.getLostAndFoundCode());
        return new RESTResponse(data);
    }

    private void postValidateParameter(JSONObject jo) {
        if (!jo.containsKey("lostAndFoundType") || StringUtils.isBlank(jo.getString("lostAndFoundType"))) {
            throw new ZAException("lostAndFoundType为空");
        }
        if (!"1".equals(jo.getString("lostAndFoundType")) && !"2".equals(jo.getString("lostAndFoundType"))) {
            throw new ZAException("lostAndFoundType只能为1或2");
        }
        if (!jo.containsKey("petGender") || StringUtils.isBlank(jo.getString("petGender"))) {
            throw new ZAException("petGender为空");
        }
        if (!"1".equals(jo.getString("petGender")) && !"2".equals(jo.getString("petGender"))) {
            throw new ZAException("petGender只能为1或2");
        }
        if (!jo.containsKey("petType") || StringUtils.isBlank(jo.getString("petType"))) {
            throw new ZAException("petType为空");
        }
        if (!"1".equals(jo.getString("petType")) && !"2".equals(jo.getString("petType"))) {
            throw new ZAException("petType只能为1或2");
        }
        if (!jo.containsKey("city") || StringUtils.isBlank(jo.getString("city"))) {
            throw new ZAException("city为空");
        }
        if (!jo.containsKey("location") || StringUtils.isBlank(jo.getString("location"))) {
            throw new ZAException("location为空");
        }
        if (!jo.containsKey("time") || StringUtils.isBlank(jo.getString("time"))) {
            throw new ZAException("time为空");
        }
        try {
            new SimpleDateFormat("yyyy-MM-dd").parse(jo.getString("time"));
        } catch (Exception e) {
            throw new ZAException("日期格式有误");
        }
    }

    private PetLostAndFound buildPo(JSONObject jo) {
        PetLostAndFound po = new PetLostAndFound();
        po.setLostAndFoundCode(System.currentTimeMillis()+"");
        po.setLostAndFoundType(jo.getString("lostAndFoundType"));
        po.setIdentificationFlag(jo.getString("identificationFlag"));
        po.setPetName(jo.getString("petName"));
        po.setPetType(jo.getString("petType"));
        po.setPetGender(jo.getString("petGender"));
        po.setPetCoatColor(jo.getString("petCoatColor"));
        po.setCity(jo.getString("city"));
        po.setLocation(jo.getString("location"));
        try {
            po.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(jo.getString("time")));
        } catch (Exception e) {

        }
        po.setPhone(jo.getString("phone"));
        po.setLinkman(jo.getString("linkman"));
        po.setRemarks(jo.getString("remarks"));
        po.setPicture(jo.getString("picture"));
        User user = new User();
        user.setId("1");
        po.setCreateBy(user);
        po.setUpdateBy(user);
        return po;
    }

    private JSONObject buildJo(PetLostAndFound po, HttpServletRequest request) {
        JSONObject data = new JSONObject();
        data.put("id", po.getId());
        data.put("lostAndFoundCode", po.getLostAndFoundCode());
        data.put("lostAndFoundType", DictUtils.getDictLabel(po.getLostAndFoundType(), "lost_and_found_type", ""));
        data.put("identificationFlag", po.getIdentificationFlag());
        data.put("petName", po.getPetName());
        data.put("petType", DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        data.put("petGender", DictUtils.getDictLabel(po.getPetGender(), "pet_gender", ""));
        data.put("petCoatColor", po.getPetCoatColor());
        data.put("city", po.getCity());
        data.put("location", po.getLocation());
        String time = "";
        if (po.getTime() != null) {
            time = DateFormatUtils.format(po.getTime(), "yyyy-MM-dd");
        }
        data.put("time", time);
        data.put("phone", po.getPhone());
        data.put("remarks",po.getRemarks());
        data.put("linkman", po.getLinkman());
        JSONArray picture = new JSONArray();
        if (StringUtils.isNotBlank(po.getPicture())) {
            for (String pictureId : po.getPicture().split(",")) {
                picture.add(ImgUtil.getImgUrl(request, pictureId));
            }
        }
        data.put("picture", picture);
        return data;
    }

    @Transactional(readOnly = false)
    public int savaReview(PetLostAndFound petLostAndFound) {
        PetLostAndFound p = dao.get(petLostAndFound.getId());
        if(p == null){
            throw new ZAException("宠物信息不存在");
        }
       if("1".equals(p.getReviewState())){
           throw new ZAException("宠物信息已经通过审核");
       }
       return dao.update(petLostAndFound);
    }
}