<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>宠物店管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/petStore/">用户列表</a></li>
    <li class="active"><a href="${ctx}/petStore/form?id=${petStore.id}">用户详情</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="petStore" action="${ctx}/petStore/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">激活码：</label>
        <div class="controls">
                ${petStore.inviteCode}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">用户名：</label>
        <div class="controls">
                ${petStore.petStoreOwnerName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">手机号：</label>
        <div class="controls">
                ${petStore.petStoreOwnerMobile}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">微信：</label>
        <div class="controls">
                ${petStore.wxOpenId}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物店名称：</label>
        <div class="controls">
                ${petStore.petStoreName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物店所在城市：</label>
        <div class="controls">
                ${petStore.petStoreCity}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物店详细地址：</label>
        <div class="controls">
            <form:input path="petStoreAddress" htmlEscape="false" maxlength="300" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">营业执照号：</label>
        <div class="controls">
                ${petStore.businessLicenseNumber}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物店联系方式：</label>
        <div class="controls">
            <form:input path="petStoreMobile" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物店面积：</label>
        <div class="controls">
                ${petStore.petStoreArea}㎡
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">主营项目：</label>
        <div class="controls">
                ${petStore.mainProject}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否有CKU认证的美容师/训练师：</label>
        <div class="controls">
            <c:if test="${petStore.ckuGroomerTrainerFlag == 1}">是</c:if>
            <c:if test="${petStore.ckuGroomerTrainerFlag != 1}">否</c:if>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系犬舍次数：</label>
        <div class="controls">
                ${petStore.contactPetOwnerCount}次
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">展示页面登录次数：</label>
        <div class="controls">
                ${petStore.viewPetOwnerCount}次
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系该宠物店次数：</label>
        <div class="controls">
                ${petStore.contactPetStoreCount}次
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="petStore:view"><input id="btnSubmit" class="btn btn-primary" type="submit"
                                                         value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>