package com.cab.passport.awards.pub.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.cab.passport.awards.model.AwardsRequestDto;
import com.cab.passport.awards.model.AwardsResponseDto;
import com.cab.passport.awards.model.AwardsWinnerDto;
import com.cab.passport.awards.service.AwardsWinnerService;
import com.cab.passport.common.ResultVo;

@RestController
@RequestMapping(value = "/pub/awards")
public class PubAwardsController {

	@Autowired
	private AwardsWinnerService awardsWinnerService;
	
	@ResponseBody
	@GetMapping(value = "/list")
	public ResultVo<AwardsResponseDto> list(AwardsRequestDto request) {
		return awardsWinnerService.list(request);
	}
	
	@ResponseBody
	@GetMapping(value = "/detail")
	public ResultVo<AwardsWinnerDto> detail(AwardsRequestDto request) {
		return awardsWinnerService.detail(request);
	}

}
