/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.web;

import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.service.PassportOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 护照订单Controller
 *
 * @author lgl
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "${adminPath}/passportorder/passportOrder")
public class PassportOrderController extends BaseController {

    @Autowired
    private PassportOrderService passportOrderService;

    @ModelAttribute
    public PassportOrder get(@RequestParam(required = false) String id) {
        PassportOrder entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = passportOrderService.get(id);
        }
        if (entity == null) {
            entity = new PassportOrder();
        }
        return entity;
    }

    @RequiresPermissions("passportorder:passportOrder:view")
    @RequestMapping(value = {"list", ""})
    public String list(PassportOrder passportOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<PassportOrder> page = passportOrderService.findPage(new Page<PassportOrder>(request, response), passportOrder);
        model.addAttribute("page", page);
        return "passport/passportorder/passportOrderList";
    }

    @RequiresPermissions("passportorder:passportOrder:view")
    @RequestMapping(value = "form")
    public String form(PassportOrder passportOrder, Model model) {
        model.addAttribute("passportOrder", passportOrder);
        return "passport/passportorder/passportOrderForm";
    }

    @RequiresPermissions("passportorder:passportOrder:edit")
    @RequestMapping(value = "save")
    public String save(PassportOrder passportOrder, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, passportOrder)) {
            return form(passportOrder, model);
        }
        passportOrderService.save(passportOrder);
        addMessage(redirectAttributes, "保存护照订单成功");
        return "redirect:" + Global.getAdminPath() + "/passportorder/passportOrder/?repage";
    }

    @RequiresPermissions("passportorder:passportOrder:edit")
    @RequestMapping(value = "delete")
    public String delete(PassportOrder passportOrder, RedirectAttributes redirectAttributes) {
        passportOrderService.delete(passportOrder);
        addMessage(redirectAttributes, "删除护照订单成功");
        return "redirect:" + Global.getAdminPath() + "/passportorder/passportOrder/?repage";
    }

}