
package com.cab.passport.sys.app;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.cab.passport.sys.util.MultiUserProfile;
import com.cab.passport.sys.util.TokenUtil;

import net.sf.json.JSONObject;

public class APPUserUtils {

	@Autowired
	static RestTemplate restTemplate;

	public static MultiUserProfile getLoginUser() {
		ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder
				.getRequestAttributes();
		if (servletRequestAttributes != null && servletRequestAttributes.getRequest() != null
				&& StringUtils.isNotBlank(servletRequestAttributes.getRequest().getHeader("token"))) {
			HttpServletRequest request = servletRequestAttributes.getRequest();
			String token = request.getHeader("token");
			if (StringUtils.isBlank(token)) {
				// 如果没有登录，则返回实例化空的User对象。
				return new MultiUserProfile();
			}
			String subject = TokenUtil.parseJwt(token).getSubject();
			JSONObject jsonObject = JSONObject.fromObject(subject);
			MultiUserProfile userProfile = (MultiUserProfile) JSONObject.toBean(jsonObject, MultiUserProfile.class);
			return userProfile;
		}
		return new MultiUserProfile();
	}

}
