package com.cab.passport.petlostandfound.pub.web;

import com.cab.passport.petlostandfound.service.PetLostAndFoundService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * 寻宠寻主Controller
 *
 * @author wangdong
 * @version 2018-10-24
 */
@Controller
@RequestMapping(value = "pub/petLostAndFound")
public class PubPetLostAndFoundController extends BaseController {
    @Autowired
    private PetLostAndFoundService petLostAndFoundService;

    @RequestMapping(value = "getById/{id}", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse get(@PathVariable("id") String id, HttpServletRequest request) {
        return petLostAndFoundService.get(id, request);
    }

    @RequestMapping(value = "", method = RequestMethod.POST)
    @ResponseBody
    public RESTResponse post(@RequestBody String json) {
        return petLostAndFoundService.post(json);
    }

    @RequestMapping(value = "search", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse search(HttpServletRequest request) {
        return petLostAndFoundService.search(request);
    }
}
