<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>伴侣级鉴定管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/passportOrder//companionDogAppraisal/">伴侣级鉴定列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="companionDogAppraisal" action="${ctx}/passportOrder/companionDogAppraisal/"
           method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>宠物主人：</label>
            <form:input path="petOwner" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>宠主手机号：</label>
            <form:input path="petOwnerMobile" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠物类型：</label>
            <form:select path="petType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('pet_types')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>审核状态：</label>
            <form:select path="appraisalResult" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('appraisal_result')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>宠物类型</th>
        <th>宠物姓名</th>
        <th>出生日期</th>
        <th>宠物主人</th>
        <th>宠主手机号</th>
        <th>芯片号</th>
        <th>鉴定结果</th>
        <th>鉴定机构</th>
        <th>是否缴费</th>
        <th>身份贴纸</th>
        <th>等级贴纸</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="companionDogAppraisal">
        <tr>
            <td>
                    ${fns:getDictLabel(companionDogAppraisal.petType, 'pet_types', '')}
            </td>
            <td>
                    ${companionDogAppraisal.petName}
            </td>
            <td>
                <fmt:formatDate value="${companionDogAppraisal.petBirthdate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${companionDogAppraisal.petOwner}
            </td>
            <td>
                    ${companionDogAppraisal.petOwnerMobile}
            </td>

            <td>
                    ${companionDogAppraisal.identificationFlag}
            </td>
            <td>
                    ${fns:getDictLabel(companionDogAppraisal.appraisalResult, 'appraisal_result', '')}
            </td>
            <td>
                    ${companionDogAppraisal.appraisalShop}
            </td>
            <td>
                <c:if test="${companionDogAppraisal.paymentState!='2' }">
                    <font style="color:red;">未缴费</font>
                </c:if>
                <c:if test="${companionDogAppraisal.paymentState=='2'}">
                    <font style="color:green;">已缴费</font>
                </c:if>
            </td>
            <%--<td>--%>
                <%--<a href="${ctx}/passportOrder/companionDogAppraisal/form?id=${companionDogAppraisal.id}&operation=1">查看</a>--%>
                <%--&lt;%&ndash;<c:if test="${companionDogAppraisal.paymentState=='2'}">&ndash;%&gt;--%>
                    <%--&lt;%&ndash;<c:if test="${companionDogAppraisal.appraisalResult=='0'}">&ndash;%&gt;--%>
                        <%--&lt;%&ndash;<a href="${ctxPartner}/companionDogAppraisal/form?id=${companionDogAppraisal.id}&operation=2">修改</a>&ndash;%&gt;--%>
                    <%--&lt;%&ndash;</c:if>&ndash;%&gt;--%>
                    <%--&lt;%&ndash;<c:if test="${companionDogAppraisal.appraisalResult !='0'}">&ndash;%&gt;--%>
                    <%--&lt;%&ndash;</c:if>&ndash;%&gt;--%>
                <%--&lt;%&ndash;</c:if>&ndash;%&gt;--%>
                <%--&lt;%&ndash;<c:if test="${companionDogAppraisal.paymentState!='2'}">&ndash;%&gt;--%>
                    <%--&lt;%&ndash;<a href="${ctxPartner}/companionDogAppraisal/form?id=${companionDogAppraisal.id}&operation=2">修改</a>&ndash;%&gt;--%>
                    <%--&lt;%&ndash;<a href="${ctxPartner}/companionDogAppraisal/delete?id=${companionDogAppraisal.id}"&ndash;%&gt;--%>
                       <%--&lt;%&ndash;onclick="return confirmx('确认要删除该伴侣级鉴定吗？', this.href)">删除</a>&ndash;%&gt;--%>
                <%--&lt;%&ndash;</c:if>&ndash;%&gt;--%>

            <%--</td>--%>
            <td>
                <c:if test="${companionDogAppraisal.paymentState=='2'&& companionDogAppraisal.appraisalResult=='1'}">
                    <c:if test="${companionDogAppraisal.identitySticker=='0' }">
                        <a style="color:red;"
                           href="${ctx}/passportOrder/companionDogAppraisal/identityPrint?id=${companionDogAppraisal.id}">打印</a>
                    </c:if>
                    <c:if test="${companionDogAppraisal.identitySticker=='1'}">
                        <a style="color:green;"
                           href="${ctx}/passportOrder/companionDogAppraisal/restIdentityPrint?id=${companionDogAppraisal.id}">重置打印</a>
                    </c:if>
                </c:if>

            </td>
            <td>
                <c:if test="${companionDogAppraisal.paymentState=='2'&& companionDogAppraisal.appraisalResult=='1'}">
                    <c:if test="${companionDogAppraisal.gradeSticker=='0' }">
                        <a style="color:red;"
                           href="${ctx}/passportOrder/companionDogAppraisal/gradePrint?id=${companionDogAppraisal.id}">打印</a>
                    </c:if>
                    <c:if test="${companionDogAppraisal.gradeSticker=='1' }">
                        <a style="color:green;"
                           href="${ctx}/passportOrder/companionDogAppraisal/restGradePrint?id=${companionDogAppraisal.id}">重置打印</a>
                    </c:if>
                </c:if>
            </td>

        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>