/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.web;

import com.cab.passport.sys.payment.entity.PaymentRecord;
import com.cab.passport.sys.payment.service.PaymentChargingItemService;
import com.cab.passport.sys.payment.service.PaymentRecordService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * 会员支付流水Controller
 * @author lyy
 * @version 2016-07-18
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentRecord")
public class PaymentRecordController extends BaseController {

	@Autowired
	private PaymentRecordService paymentRecordService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@ModelAttribute
	public PaymentRecord get(@RequestParam(required=false) String id) {
		PaymentRecord entity = null;
		if (StringUtils.isNotBlank(id)){
			entity =  paymentRecordService.get(id);
		}
		if (entity == null){
			entity = new PaymentRecord();
		}
		return entity;
	}

	@RequiresPermissions("finance:paymentRecord:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentRecord paymentRecord, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentRecord> page = paymentRecordService.findPage(new Page<PaymentRecord>(request, response), paymentRecord);
		model.addAttribute("page", page);
		return "oa/finance/paymentRecordList";
	}

	@RequiresPermissions("finance:paymentRecord:view")
	@RequestMapping(value = "form")
	public String form(PaymentRecord paymentRecord, Model model) {
		model.addAttribute("paymentRecord", paymentRecord);
		return "oa/finance/paymentRecordForm";
	}

	@RequiresPermissions("finance:paymentRecord:edit")
	@RequestMapping(value = "save")
	public String save(PaymentRecord paymentRecord, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentRecord)){
			return form(paymentRecord, model);
		}
		paymentRecordService.save(paymentRecord);
		addMessage(redirectAttributes, "保存会员支付流水成功");
		return "redirect:"+ Global.getAdminPath()+"/finance/paymentRecord/?repage";
	}

	@RequiresPermissions("finance:paymentRecord:edit")
	@RequestMapping(value = "delete")
	public String delete(PaymentRecord paymentRecord, RedirectAttributes redirectAttributes) {
		paymentRecordService.delete(paymentRecord);
		addMessage(redirectAttributes, "删除会员支付流水成功");
		return "redirect:"+ Global.getAdminPath()+"/finance/paymentRecord/?repage";
	}
}