/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 护照订单Entity
 *
 * @author lgl
 * @version 2018-10-09
 */
public class PassportOrder extends DataEntity<PassportOrder> {

    private static final long serialVersionUID = 1L;
    private String tmallOrderCode;        // 天猫订单号
    @ExcelField(title = "物品名称", align = 2, sort = 8)
    private String packageType;        // 套餐类型:1套餐A ：护照+芯片;2套餐B：护照+芯片+C级;3套餐C：护照+芯片+检测卡+保险;4套餐D：护照+芯片+C级+检测卡+保险
    private Date orderTime;        // 下单时间
    private String wangwangId;        // 旺旺id
    @ExcelField(title = "收件人姓名", align = 2, sort = 1)
    private String consigneeName;        // 收货人姓名
    @ExcelField(title = "收件人手机", align = 2, sort = 2)
    private String consigneePhone;        // 收货人电话
    @ExcelField(title = "收件人固话", align = 2, sort = 3)
    private String consigneeLandline;        // 收货人固定电话
    @ExcelField(title = "省", align = 2, sort = 4)
    private String consigneeProvince;        // 收货人省
    @ExcelField(title = "市", align = 2, sort = 5)
    private String consigneeCity;        // 收货人城市
    @ExcelField(title = "详细地址", align = 2, sort = 7)
    private String consigneeAddress;        // 收货人地址
    @ExcelField(title = "区(县)", align = 2, sort = 6)
    private String consigneeDistrict;        // 收货人区(县)
    private String petName;        // 宠物名称
    private String petType;        // 宠物种类:1狗;2猫
    private String petGender;        // 宠物性别:1公;2母
    private Date petBirthday;        // 宠物生日
    private String petCoatColor;        // 宠物毛色
    private String businessState;        // 业务状态
    private String identificationFlag;        // 芯片号
    private String cabPassport;        // 护照号
    private String cabRegisterCode;        // 宠爱登记卡号
    private String expressType;        // 快递类型
    private String expressNumber;        // 快递号
    @ExcelField(title = "重量", align = 2, sort = 9)
    private String expressWeight;        // 快递重量
    private String petOwnerName;        // 宠物主人姓名
    private String petOwnerMobile;        // 宠物主人手机号
    private String petOwnerAddress;        // 宠物主人地址
    private String activateBy;        // 激活者
    private Date activateDate;        // 激活时间
    private String certifyBy;        // 认证者
    private Date certifyDate;        // 认证时间
    private String certifyResult;        // 认证结果:0认证成功;1认证失败

    public PassportOrder() {
        super();
    }

    public PassportOrder(String id) {
        super(id);
    }

    @Length(min = 1, max = 20, message = "天猫订单号长度必须介于 1 和 20 之间")
    public String getTmallOrderCode() {
        return tmallOrderCode;
    }

    public void setTmallOrderCode(String tmallOrderCode) {
        this.tmallOrderCode = tmallOrderCode;
    }

    @Length(min = 1, max = 1, message = "套餐类型:1套餐A ：护照+芯片;2套餐B：护照+芯片+C级;3套餐C：护照+芯片+检测卡+保险;4套餐D：护照+芯片+C级+检测卡+保险长度必须介于 1 和 1 之间")
    public String getPackageType() {
        return packageType;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "下单时间不能为空")
    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    @Length(min = 1, max = 20, message = "旺旺id长度必须介于 1 和 20 之间")
    public String getWangwangId() {
        return wangwangId;
    }

    public void setWangwangId(String wangwangId) {
        this.wangwangId = wangwangId;
    }

    @Length(min = 1, max = 10, message = "收货人姓名长度必须介于 1 和 10 之间")
    public String getConsigneeName() {
        return consigneeName;
    }

    public void setConsigneeName(String consigneeName) {
        this.consigneeName = consigneeName;
    }

    @Length(min = 1, max = 20, message = "收货人电话长度必须介于 1 和 20 之间")
    public String getConsigneePhone() {
        return consigneePhone;
    }

    public void setConsigneePhone(String consigneePhone) {
        this.consigneePhone = consigneePhone;
    }

    public String getConsigneeLandline() {
        return consigneeLandline;
    }

    public void setConsigneeLandline(String consigneeLandline) {
        this.consigneeLandline = consigneeLandline;
    }

    public String getConsigneeProvince() {
        return consigneeProvince;
    }

    public void setConsigneeProvince(String consigneeProvince) {
        this.consigneeProvince = consigneeProvince;
    }

    public String getConsigneeCity() {
        return consigneeCity;
    }

    public void setConsigneeCity(String consigneeCity) {
        this.consigneeCity = consigneeCity;
    }

    public String getConsigneeDistrict() {
        return consigneeDistrict;
    }

    public void setConsigneeDistrict(String consigneeDistrict) {
        this.consigneeDistrict = consigneeDistrict;
    }

    @Length(min = 1, max = 200, message = "收货人地址长度必须介于 1 和 200 之间")
    public String getConsigneeAddress() {
        return consigneeAddress;
    }

    public void setConsigneeAddress(String consigneeAddress) {
        this.consigneeAddress = consigneeAddress;
    }

    @Length(min = 1, max = 50, message = "宠物名称长度必须介于 1 和 50 之间")
    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    @Length(min = 1, max = 1, message = "宠物种类:1狗;2猫长度必须介于 1 和 1 之间")
    public String getPetType() {
        return petType;
    }

    public void setPetType(String petType) {
        this.petType = petType;
    }

    @Length(min = 1, max = 1, message = "宠物性别:1公;2母长度必须介于 1 和 1 之间")
    public String getPetGender() {
        return petGender;
    }

    public void setPetGender(String petGender) {
        this.petGender = petGender;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "宠物生日不能为空")
    public Date getPetBirthday() {
        return petBirthday;
    }

    public void setPetBirthday(Date petBirthday) {
        this.petBirthday = petBirthday;
    }

    @Length(min = 1, max = 50, message = "宠物毛色长度必须介于 1 和 50 之间")
    public String getPetCoatColor() {
        return petCoatColor;
    }

    public void setPetCoatColor(String petCoatColor) {
        this.petCoatColor = petCoatColor;
    }

    @Length(min = 1, max = 1, message = "业务状态长度必须介于 1 和 1 之间")
    public String getBusinessState() {
        return businessState;
    }

    public void setBusinessState(String businessState) {
        this.businessState = businessState;
    }

    @Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
    public String getIdentificationFlag() {
        return identificationFlag;
    }

    public void setIdentificationFlag(String identificationFlag) {
        this.identificationFlag = identificationFlag;
    }

    @Length(min = 1, max = 20, message = "护照号长度必须介于 1 和 20 之间")
    public String getCabPassport() {
        return cabPassport;
    }

    public void setCabPassport(String cabPassport) {
        this.cabPassport = cabPassport;
    }

    @Length(min = 1, max = 20, message = "宠爱登记卡号长度必须介于 1 和 20 之间")
    public String getCabRegisterCode() {
        return cabRegisterCode;
    }

    public void setCabRegisterCode(String cabRegisterCode) {
        this.cabRegisterCode = cabRegisterCode;
    }

    @Length(min = 0, max = 1, message = "快递类型长度必须介于 0 和 1 之间")
    public String getExpressType() {
        return expressType;
    }

    public void setExpressType(String expressType) {
        this.expressType = expressType;
    }

    @Length(min = 1, max = 50, message = "快递号长度必须介于 1 和 50 之间")
    public String getExpressNumber() {
        return expressNumber;
    }

    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
    }

    public String getExpressWeight() {
        return expressWeight;
    }

    public void setExpressWeight(String expressWeight) {
        this.expressWeight = expressWeight;
    }

    public String getPetOwnerName() {
        return petOwnerName;
    }

    public void setPetOwnerName(String petOwnerName) {
        this.petOwnerName = petOwnerName;
    }

    public String getPetOwnerMobile() {
        return petOwnerMobile;
    }

    public void setPetOwnerMobile(String petOwnerMobile) {
        this.petOwnerMobile = petOwnerMobile;
    }

    public String getPetOwnerAddress() {
        return petOwnerAddress;
    }

    public void setPetOwnerAddress(String petOwnerAddress) {
        this.petOwnerAddress = petOwnerAddress;
    }

    @Length(min = 0, max = 64, message = "激活者长度必须介于 0 和 64 之间")
    public String getActivateBy() {
        return activateBy;
    }

    public void setActivateBy(String activateBy) {
        this.activateBy = activateBy;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getActivateDate() {
        return activateDate;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = activateDate;
    }

    @Length(min = 0, max = 64, message = "认证者长度必须介于 0 和 64 之间")
    public String getCertifyBy() {
        return certifyBy;
    }

    public void setCertifyBy(String certifyBy) {
        this.certifyBy = certifyBy;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCertifyDate() {
        return certifyDate;
    }

    public void setCertifyDate(Date certifyDate) {
        this.certifyDate = certifyDate;
    }

    public String getCertifyResult() {
        return certifyResult;
    }

    public void setCertifyResult(String certifyResult) {
        this.certifyResult = certifyResult;
    }

    private String activateDateNotNull;        // 激活时间不为空
    private String certifyDateNotNull;        // 认证时间不为空
    private String tmallOrderCodeLike;        // 天猫订单号模糊查询
    private String wangwangIdLike;        // 旺旺id模糊查询
    private String consigneePhoneLike;        // 收货人电话模糊查询
    private String identificationFlagLike;        // 芯片号模糊查询
    private String cabPassportLike;        // 护照号模糊查询
    private Date activateDateStart;// 激活时间开始
    private Date activateDateEnd;// 激活时间结束
    private Date certifyDateStart;// 认证时间开始
    private Date certifyDateEnd;// 认证时间结束

    public String getActivateDateNotNull() {
        return activateDateNotNull;
    }

    public void setActivateDateNotNull(String activateDateNotNull) {
        this.activateDateNotNull = activateDateNotNull;
    }

    public String getCertifyDateNotNull() {
        return certifyDateNotNull;
    }

    public void setCertifyDateNotNull(String certifyDateNotNull) {
        this.certifyDateNotNull = certifyDateNotNull;
    }

    public String getTmallOrderCodeLike() {
        return tmallOrderCodeLike;
    }

    public void setTmallOrderCodeLike(String tmallOrderCodeLike) {
        this.tmallOrderCodeLike = tmallOrderCodeLike;
    }

    public String getWangwangIdLike() {
        return wangwangIdLike;
    }

    public void setWangwangIdLike(String wangwangIdLike) {
        this.wangwangIdLike = wangwangIdLike;
    }

    public String getConsigneePhoneLike() {
        return consigneePhoneLike;
    }

    public void setConsigneePhoneLike(String consigneePhoneLike) {
        this.consigneePhoneLike = consigneePhoneLike;
    }

    public String getIdentificationFlagLike() {
        return identificationFlagLike;
    }

    public void setIdentificationFlagLike(String identificationFlagLike) {
        this.identificationFlagLike = identificationFlagLike;
    }

    public String getCabPassportLike() {
        return cabPassportLike;
    }

    public void setCabPassportLike(String cabPassportLike) {
        this.cabPassportLike = cabPassportLike;
    }

    public Date getActivateDateStart() {
        return activateDateStart;
    }

    public void setActivateDateStart(Date activateDateStart) {
        this.activateDateStart = activateDateStart;
    }

    public Date getActivateDateEnd() {
        return activateDateEnd;
    }

    public void setActivateDateEnd(Date activateDateEnd) {
        this.activateDateEnd = activateDateEnd;
    }

    public Date getCertifyDateStart() {
        return certifyDateStart;
    }

    public void setCertifyDateStart(Date certifyDateStart) {
        this.certifyDateStart = certifyDateStart;
    }

    public Date getCertifyDateEnd() {
        return certifyDateEnd;
    }

    public void setCertifyDateEnd(Date certifyDateEnd) {
        this.certifyDateEnd = certifyDateEnd;
    }

    private String tmallBusinessState;        // 天猫业务状态

    public String getTmallBusinessState() {
        return tmallBusinessState;
    }

    public void setTmallBusinessState(String tmallBusinessState) {
        this.tmallBusinessState = tmallBusinessState;
    }
}